/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.io.IoFilter;
import org.apache.mina.io.IoFilterAdapter;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.filter.SSLHandler;

public class SSLFilter
extends IoFilterAdapter {
    public static final String SSL_SESSION = SSLFilter.class.getName() + ".SSLSession";
    private static final String SSL_HANDLER = SSLFilter.class.getName() + ".SSLHandler";
    private static final Logger log = Logger.getLogger(SSLFilter.class.getName());
    private static final Object SSL_MARKER = new Object(){

        public String toString() {
            return "SSL_MARKER";
        }
    };
    private SSLContext sslContext;
    private boolean client;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;

    public SSLFilter(SSLContext sslContext) {
        if (sslContext == null) {
            throw new NullPointerException("sslContext");
        }
        this.sslContext = sslContext;
    }

    public SSLSession getSSLSession(IoSession session) {
        return (SSLSession)session.getAttribute(SSL_SESSION);
    }

    public boolean isUseClientMode() {
        return this.client;
    }

    public void setUseClientMode(boolean clientMode) {
        this.client = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.enabledCipherSuites = cipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = protocols;
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        this.createSSLSessionHandler(nextFilter, session);
        nextFilter.sessionOpened(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SSLHandler sslHandler = this.getSSLSessionHandler(session);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, session + " Closed: " + sslHandler);
        }
        if (sslHandler != null) {
            SSLHandler sSLHandler = sslHandler;
            synchronized (sSLHandler) {
                try {
                    sslHandler.shutdown();
                    this.writeNetBuffer(nextFilter, session, sslHandler);
                }
                finally {
                    nextFilter.sessionClosed(session);
                    sslHandler.release();
                    this.removeSSLSessionHandler(session);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRead(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf) throws SSLException {
        SSLHandler sslHandler = this.createSSLSessionHandler(nextFilter, session);
        if (sslHandler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, session + " Data Read: " + sslHandler + " (" + buf + ')');
            }
            SSLHandler sSLHandler = sslHandler;
            synchronized (sSLHandler) {
                try {
                    sslHandler.dataRead(nextFilter, buf.buf());
                    this.handleSSLData(nextFilter, session, sslHandler);
                    if (sslHandler.isClosed()) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, session + " SSL Session closed. Closing connection..");
                        }
                        session.close();
                    }
                }
                catch (SSLException ssle2) {
                    SSLHandshakeException ssle2;
                    if (!sslHandler.isInitialHandshakeComplete()) {
                        SSLHandshakeException newSSLE = new SSLHandshakeException("Initial SSL handshake failed.");
                        newSSLE.initCause(ssle2);
                        ssle2 = newSSLE;
                    }
                    throw ssle2;
                }
            }
        }
        nextFilter.dataRead(session, buf);
    }

    public void dataWritten(IoFilter.NextFilter nextFilter, IoSession session, Object marker) {
        if (marker != SSL_MARKER) {
            nextFilter.dataWritten(session, marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf, Object marker) throws SSLException {
        SSLHandler handler = this.createSSLSessionHandler(nextFilter, session);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, session + " Filtered Write: " + handler);
        }
        SSLHandler sSLHandler = handler;
        synchronized (sSLHandler) {
            if (handler.isWritingEncryptedData()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, session + "   already encrypted: " + buf);
                }
                nextFilter.filterWrite(session, buf, marker);
                return;
            }
            if (handler.isInitialHandshakeComplete()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, session + " encrypt: " + buf);
                }
                handler.encrypt(buf.buf());
                ByteBuffer encryptedBuffer = SSLFilter.copy(handler.getOutNetBuffer());
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, session + " encrypted buf: " + encryptedBuffer);
                }
                buf.release();
                nextFilter.filterWrite(session, encryptedBuffer, marker);
                return;
            }
            if (!session.isConnected()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, session + " Write request on closed session.");
                }
            } else {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, session + " Handshaking is not complete yet. Buffering write request.");
                }
                handler.scheduleWrite(nextFilter, buf, marker);
            }
        }
    }

    private void handleSSLData(IoFilter.NextFilter nextFilter, IoSession session, SSLHandler handler) throws SSLException {
        if (handler.isInitialHandshakeComplete()) {
            handler.flushScheduledWrites();
        }
        this.writeNetBuffer(nextFilter, session, handler);
        this.handleAppDataRead(nextFilter, session, handler);
    }

    private void handleAppDataRead(IoFilter.NextFilter nextFilter, IoSession session, SSLHandler sslHandler) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, session + " appBuffer: " + sslHandler.getAppBuffer());
        }
        if (sslHandler.getAppBuffer().hasRemaining()) {
            ByteBuffer readBuffer = SSLFilter.copy(sslHandler.getAppBuffer());
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, session + " app data read: " + readBuffer + " (" + readBuffer.getHexDump() + ')');
            }
            nextFilter.dataRead(session, readBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeNetBuffer(IoFilter.NextFilter nextFilter, IoSession session, SSLHandler sslHandler) throws SSLException {
        if (!sslHandler.getOutNetBuffer().hasRemaining()) {
            return;
        }
        SSLHandler sSLHandler = sslHandler;
        synchronized (sSLHandler) {
            sslHandler.setWritingEncryptedData(true);
        }
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, session + " write outNetBuffer: " + sslHandler.getOutNetBuffer());
            }
            ByteBuffer writeBuffer = SSLFilter.copy(sslHandler.getOutNetBuffer());
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, session + " session write: " + writeBuffer);
            }
            this.filterWrite(nextFilter, session, writeBuffer, SSL_MARKER);
            while (sslHandler.needToCompleteInitialHandshake()) {
                try {
                    sslHandler.continueHandshake(nextFilter);
                }
                catch (SSLException ssle) {
                    SSLHandshakeException newSSLE = new SSLHandshakeException("Initial SSL handshake failed.");
                    newSSLE.initCause(ssle);
                    throw newSSLE;
                }
                if (!sslHandler.getOutNetBuffer().hasRemaining()) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, session + " write outNetBuffer2: " + sslHandler.getOutNetBuffer());
                }
                ByteBuffer writeBuffer2 = SSLFilter.copy(sslHandler.getOutNetBuffer());
                this.filterWrite(nextFilter, session, writeBuffer2, SSL_MARKER);
            }
        }
        finally {
            sSLHandler = sslHandler;
            synchronized (sSLHandler) {
                sslHandler.setWritingEncryptedData(false);
            }
        }
    }

    private static ByteBuffer copy(java.nio.ByteBuffer src) {
        ByteBuffer copy = ByteBuffer.allocate(src.remaining());
        copy.put(src);
        copy.flip();
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLHandler createSSLSessionHandler(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SSLHandler handler = this.getSSLSessionHandler(session);
        if (handler == null) {
            IoSession ioSession = session;
            synchronized (ioSession) {
                handler = this.getSSLSessionHandler(session);
                if (handler == null) {
                    boolean done = false;
                    try {
                        handler = new SSLHandler(this, this.sslContext, session);
                        session.setAttribute(SSL_HANDLER, handler);
                        handler.doHandshake(nextFilter);
                        done = true;
                    }
                    finally {
                        if (!done) {
                            session.removeAttribute(SSL_HANDLER);
                        }
                    }
                }
            }
        }
        return handler;
    }

    private SSLHandler getSSLSessionHandler(IoSession session) {
        return (SSLHandler)session.getAttribute(SSL_HANDLER);
    }

    private void removeSSLSessionHandler(IoSession session) {
        session.removeAttribute(SSL_HANDLER);
    }
}

