/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.io;

import java.net.SocketAddress;
import java.util.Set;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.io.IoSession;
import org.apache.mina.protocol.ProtocolDecoder;
import org.apache.mina.protocol.ProtocolEncoder;
import org.apache.mina.protocol.ProtocolFilterChain;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolSessionFilterChain;
import org.apache.mina.protocol.ProtocolSessionManagerFilterChain;
import org.apache.mina.protocol.SimpleProtocolDecoderOutput;
import org.apache.mina.protocol.SimpleProtocolEncoderOutput;
import org.apache.mina.protocol.io.IoAdapter;
import org.apache.mina.util.Queue;

public class IoProtocolSession
implements ProtocolSession {
    private final ProtocolSessionFilterChain filterChain;
    final IoSession session;
    final IoAdapter.SessionHandlerAdapter shAdapter;
    final Queue writeQueue = new Queue();
    final ProtocolEncoder encoder;
    final ProtocolDecoder decoder;
    final SimpleProtocolEncoderOutput encOut;
    final SimpleProtocolDecoderOutput decOut;

    IoProtocolSession(ProtocolSessionManagerFilterChain managerFilterChain, IoSession session, IoAdapter.SessionHandlerAdapter shAdapter) {
        this.filterChain = new ProtocolSessionFilterChain(managerFilterChain);
        this.session = session;
        this.shAdapter = shAdapter;
        this.encoder = shAdapter.codecFactory.newEncoder();
        this.decoder = shAdapter.codecFactory.newDecoder();
        this.encOut = new SimpleProtocolEncoderOutput();
        this.decOut = new SimpleProtocolDecoderOutput();
    }

    public IoSession getIoSession() {
        return this.session;
    }

    public ProtocolFilterChain getFilterChain() {
        return this.filterChain;
    }

    public ProtocolHandler getHandler() {
        return this.shAdapter.handler;
    }

    public ProtocolEncoder getEncoder() {
        return this.encoder;
    }

    public ProtocolDecoder getDecoder() {
        return this.decoder;
    }

    public void close() {
        this.session.close();
    }

    public void close(boolean wait) {
        this.session.close(wait);
    }

    public Object getAttachment() {
        return this.session.getAttachment();
    }

    public Object setAttachment(Object attachment) {
        return this.session.setAttachment(attachment);
    }

    public Object getAttribute(String key) {
        return this.session.getAttribute(key);
    }

    public Object setAttribute(String key, Object value) {
        return this.session.setAttribute(key, value);
    }

    public Object removeAttribute(String key) {
        return this.session.removeAttribute(key);
    }

    public Set getAttributeKeys() {
        return this.session.getAttributeKeys();
    }

    public void write(Object message) {
        this.filterChain.filterWrite(this, message);
    }

    public long getWrittenWriteRequests() {
        return this.session.getWrittenWriteRequests();
    }

    public int getScheduledWriteRequests() {
        return this.session.getScheduledWriteRequests();
    }

    public TransportType getTransportType() {
        return this.session.getTransportType();
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public SessionConfig getConfig() {
        return this.session.getConfig();
    }

    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    public long getReadBytes() {
        return this.session.getReadBytes();
    }

    public long getWrittenBytes() {
        return this.session.getWrittenBytes();
    }

    public long getLastIoTime() {
        return this.session.getLastIoTime();
    }

    public long getLastReadTime() {
        return this.session.getLastReadTime();
    }

    public long getLastWriteTime() {
        return this.session.getLastWriteTime();
    }

    public boolean isIdle(IdleStatus status) {
        return this.session.isIdle(status);
    }
}

