/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.filter;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.Session;
import org.apache.mina.io.IoFilter;
import org.apache.mina.io.IoSession;
import org.apache.mina.util.BaseThreadPool;
import org.apache.mina.util.EventType;
import org.apache.mina.util.ThreadPool;

public class IoThreadPoolFilter
extends BaseThreadPool
implements ThreadPool,
IoFilter {
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
        this.fireEvent(nextFilter, session, EventType.OPENED, null);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
        this.fireEvent(nextFilter, session, EventType.CLOSED, null);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
        this.fireEvent(nextFilter, session, EventType.IDLE, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        this.fireEvent(nextFilter, session, EventType.EXCEPTION, cause);
    }

    public void dataRead(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf) {
        buf.acquire();
        this.fireEvent(nextFilter, session, EventType.READ, buf);
    }

    public void dataWritten(IoFilter.NextFilter nextFilter, IoSession session, Object marker) {
        this.fireEvent(nextFilter, session, EventType.WRITTEN, marker);
    }

    protected void processEvent(Object nextFilter0, Session session0, EventType type, Object data) {
        IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)nextFilter0;
        IoSession session = (IoSession)session0;
        if (type == EventType.READ) {
            ByteBuffer buf = (ByteBuffer)data;
            nextFilter.dataRead(session, buf);
            buf.release();
        } else if (type == EventType.WRITTEN) {
            nextFilter.dataWritten(session, data);
        } else if (type == EventType.EXCEPTION) {
            nextFilter.exceptionCaught(session, (Throwable)data);
        } else if (type == EventType.IDLE) {
            nextFilter.sessionIdle(session, (IdleStatus)data);
        } else if (type == EventType.OPENED) {
            nextFilter.sessionOpened(session);
        } else if (type == EventType.CLOSED) {
            nextFilter.sessionClosed(session);
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf, Object marker) throws Exception {
        nextFilter.filterWrite(session, buf, marker);
    }
}

