/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class TransportType
implements Serializable {
    private static final long serialVersionUID = 3258132470497883447L;
    private static final Map name2type = new HashMap();
    public static final TransportType SOCKET = new TransportType(new String[]{"SOCKET", "TCP"}, false);
    public static final TransportType DATAGRAM = new TransportType(new String[]{"DATAGRAM", "UDP"}, true);
    public static final TransportType VM_PIPE = new TransportType(new String[]{"VM_PIPE"}, false);
    private final String[] names;
    private final transient boolean connectionless;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(String[] names, TransportType type) {
        Map map = name2type;
        synchronized (map) {
            int i;
            for (i = names.length - 1; i >= 0; --i) {
                if (!name2type.containsKey(names[i])) continue;
                throw new IllegalArgumentException("Transport type name '" + names[i] + "' is already taken.");
            }
            for (i = names.length - 1; i >= 0; --i) {
                name2type.put(names[i].toUpperCase(), type);
            }
        }
    }

    public static TransportType getInstance(String name) {
        TransportType type = (TransportType)name2type.get(name.toUpperCase());
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Unknown transport type name: " + name);
    }

    public TransportType(String[] names, boolean connectionless) {
        if (names == null) {
            throw new NullPointerException("names");
        }
        if (names.length == 0) {
            throw new IllegalArgumentException("names is empty");
        }
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) {
                throw new NullPointerException("strVals[" + i + "]");
            }
            names[i] = names[i].toUpperCase();
        }
        TransportType.register(names, this);
        this.names = names;
        this.connectionless = connectionless;
    }

    public boolean isConnectionless() {
        return this.connectionless;
    }

    public Set getNames() {
        TreeSet<String> result = new TreeSet<String>();
        for (int i = this.names.length - 1; i >= 0; --i) {
            result.add(this.names[i]);
        }
        return result;
    }

    public String toString() {
        return this.names[0];
    }

    private Object readResolve() throws ObjectStreamException {
        for (int i = this.names.length - 1; i >= 0; --i) {
            try {
                return TransportType.getInstance(this.names[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new InvalidObjectException("Unknown transport type.");
    }
}

