/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.datagram;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.io.IoAcceptor;
import org.apache.mina.io.IoFilterChain;
import org.apache.mina.io.IoHandler;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.IoSessionManagerFilterChain;
import org.apache.mina.io.datagram.DatagramSession;
import org.apache.mina.io.datagram.DatagramSessionManager;
import org.apache.mina.io.datagram.DatagramSessionManagerFilterChain;
import org.apache.mina.util.ExceptionUtil;
import org.apache.mina.util.Queue;

public class DatagramAcceptor
extends DatagramSessionManager
implements IoAcceptor {
    private static volatile int nextId = 0;
    private final IoSessionManagerFilterChain filters = new DatagramSessionManagerFilterChain(this);
    private final int id = nextId++;
    private Selector selector;
    private final Map channels = new HashMap();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final Queue flushingSessions = new Queue();
    private Worker worker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address, IoHandler handler) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (((InetSocketAddress)address).getPort() == 0) {
            throw new IllegalArgumentException("Unsupported port number: 0");
        }
        RegistrationRequest request = new RegistrationRequest(address, handler);
        Object object = this;
        synchronized (object) {
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(request);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            ExceptionUtil.throwException(request.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest request = new CancellationRequest(address);
        Object object = this;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
            Queue e = this.cancelQueue;
            synchronized (e) {
                this.cancelQueue.push(request);
            }
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            request.exception.fillInStackTrace();
            throw request.exception;
        }
    }

    public IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        Selector selector = this.selector;
        DatagramChannel ch = (DatagramChannel)this.channels.get(localAddress);
        if (selector == null || ch == null) {
            throw new IllegalArgumentException("Unknown localAddress: " + localAddress);
        }
        SelectionKey key = ch.keyFor(selector);
        if (key == null) {
            throw new IllegalArgumentException("Unknown lodalAddress: " + localAddress);
        }
        RegistrationRequest req = (RegistrationRequest)key.attachment();
        DatagramSession s = new DatagramSession(this.filters, ch, req.handler);
        s.setRemoteAddress(remoteAddress);
        s.setSelectionKey(key);
        try {
            req.handler.sessionCreated(s);
        }
        catch (Throwable t) {
            this.exceptionMonitor.exceptionCaught(this, t);
        }
        return s;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.worker.start();
        }
    }

    void flushSession(DatagramSession session) {
        this.scheduleFlush(session);
        this.selector.wakeup();
    }

    void closeSession(DatagramSession session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(DatagramSession session) {
        Queue queue = this.flushingSessions;
        synchronized (queue) {
            this.flushingSessions.push(session);
        }
    }

    private void processReadySessions(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            it.remove();
            DatagramChannel ch = (DatagramChannel)key.channel();
            RegistrationRequest req = (RegistrationRequest)key.attachment();
            DatagramSession session = new DatagramSession(this.filters, ch, req.handler);
            session.setSelectionKey(key);
            try {
                req.handler.sessionCreated(session);
                if (key.isReadable()) {
                    this.readSession(session);
                }
                if (!key.isWritable()) continue;
                this.scheduleFlush(session);
            }
            catch (Throwable t) {
                this.exceptionMonitor.exceptionCaught(this, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramSession session) {
        ByteBuffer readBuf = ByteBuffer.allocate(2048);
        try {
            SocketAddress remoteAddress = session.getChannel().receive(readBuf.buf());
            if (remoteAddress != null) {
                readBuf.flip();
                session.setRemoteAddress(remoteAddress);
                ByteBuffer newBuf = ByteBuffer.allocate(readBuf.limit());
                newBuf.put(readBuf);
                newBuf.flip();
                session.increaseReadBytes(newBuf.remaining());
                this.filters.dataRead(session, newBuf);
            }
        }
        catch (IOException e) {
            this.filters.exceptionCaught(session, e);
        }
        finally {
            readBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            DatagramSession session;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                session = (DatagramSession)this.flushingSessions.pop();
            }
            if (session == null) break;
            try {
                this.flush(session);
            }
            catch (IOException e) {
                session.getManagerFilterChain().exceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(DatagramSession session) throws IOException {
        DatagramChannel ch = session.getChannel();
        Queue writeBufferQueue = session.getWriteBufferQueue();
        Queue writeMarkerQueue = session.getWriteMarkerQueue();
        while (true) {
            Object marker;
            ByteBuffer buf;
            Queue queue = writeBufferQueue;
            synchronized (queue) {
                buf = (ByteBuffer)writeBufferQueue.first();
                marker = writeMarkerQueue.first();
            }
            if (buf == null) break;
            if (buf.remaining() == 0) {
                queue = writeBufferQueue;
                synchronized (queue) {
                    writeBufferQueue.pop();
                    writeMarkerQueue.pop();
                }
                try {
                    buf.release();
                }
                catch (IllegalStateException e) {
                    session.getManagerFilterChain().exceptionCaught(session, e);
                }
                session.increaseWrittenWriteRequests();
                session.getManagerFilterChain().dataWritten(session, marker);
                continue;
            }
            int writtenBytes = ch.send(buf.buf(), session.getRemoteAddress());
            SelectionKey key = session.getSelectionKey();
            if (writtenBytes == 0) {
                key.interestOps(key.interestOps() | 4);
                continue;
            }
            if (writtenBytes <= 0) continue;
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            Queue queue2 = writeBufferQueue;
            synchronized (queue2) {
                writeBufferQueue.pop();
                writeMarkerQueue.pop();
            }
            session.increaseWrittenBytes(writtenBytes);
            session.increaseWrittenWriteRequests();
            session.getManagerFilterChain().dataWritten(session, marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            DatagramChannel ch = null;
            try {
                ch = DatagramChannel.open();
                ch.configureBlocking(false);
                ch.socket().bind(req.address);
                ch.register(this.selector, 1, req);
                this.channels.put(req.address, ch);
                continue;
            }
            catch (Throwable t) {
                req.exception = t;
                continue;
            }
            finally {
                RegistrationRequest registrationRequest = req;
                synchronized (registrationRequest) {
                    req.done = true;
                    req.notify();
                }
                if (ch == null || req.exception == null) continue;
                try {
                    ch.close();
                }
                catch (Throwable e) {
                    this.exceptionMonitor.exceptionCaught(this, e);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            Object key;
            CancellationRequest request;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                request = (CancellationRequest)this.cancelQueue.pop();
            }
            if (request == null) return;
            DatagramChannel ch = (DatagramChannel)this.channels.remove(request.address);
            try {
                if (ch == null) {
                    request.exception = new IllegalArgumentException("Address not bound: " + request.address);
                    continue;
                }
                key = ch.keyFor(this.selector);
                ((SelectionKey)key).cancel();
                this.selector.wakeup();
                ch.close();
                continue;
            }
            catch (Throwable t) {
                this.exceptionMonitor.exceptionCaught(this, t);
                continue;
            }
            finally {
                key = request;
                synchronized (key) {
                    request.done = true;
                    request.notify();
                }
                continue;
            }
            break;
        }
    }

    public IoFilterChain getFilterChain() {
        return this.filters;
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RuntimeException exception;

        private CancellationRequest(SocketAddress address) {
            this.address = address;
        }
    }

    private static class RegistrationRequest {
        private final SocketAddress address;
        private final IoHandler handler;
        private Throwable exception;
        private boolean done;

        private RegistrationRequest(SocketAddress address, IoHandler handler) {
            this.address = address;
            this.handler = handler;
        }
    }

    private class Worker
    extends Thread {
        public Worker() {
            super("DatagramAcceptor-" + DatagramAcceptor.this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = DatagramAcceptor.this.selector.select();
                        DatagramAcceptor.this.registerNew();
                        if (nKeys > 0) {
                            DatagramAcceptor.this.processReadySessions(DatagramAcceptor.this.selector.selectedKeys());
                        }
                        DatagramAcceptor.this.flushSessions();
                        DatagramAcceptor.this.cancelKeys();
                    } while (!DatagramAcceptor.this.selector.keys().isEmpty());
                    DatagramAcceptor datagramAcceptor = DatagramAcceptor.this;
                    synchronized (datagramAcceptor) {
                        if (DatagramAcceptor.this.selector.keys().isEmpty() && DatagramAcceptor.this.registerQueue.isEmpty() && DatagramAcceptor.this.cancelQueue.isEmpty()) {
                            DatagramAcceptor.this.worker = null;
                            try {
                                DatagramAcceptor.this.selector.close();
                            }
                            catch (IOException e) {
                                DatagramAcceptor.this.exceptionMonitor.exceptionCaught(DatagramAcceptor.this, e);
                            }
                            finally {
                                DatagramAcceptor.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    DatagramAcceptor.this.exceptionMonitor.exceptionCaught(DatagramAcceptor.this, e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

