/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.datagram;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.io.IoConnector;
import org.apache.mina.io.IoFilterChain;
import org.apache.mina.io.IoHandler;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.IoSessionManagerFilterChain;
import org.apache.mina.io.datagram.DatagramSession;
import org.apache.mina.io.datagram.DatagramSessionManager;
import org.apache.mina.io.datagram.DatagramSessionManagerFilterChain;
import org.apache.mina.util.ExceptionUtil;
import org.apache.mina.util.Queue;

public class DatagramConnector
extends DatagramSessionManager
implements IoConnector {
    private static volatile int nextId = 0;
    private final IoSessionManagerFilterChain filters = new DatagramSessionManagerFilterChain(this);
    private final int id = nextId++;
    private Selector selector;
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final Queue flushingSessions = new Queue();
    private Worker worker;

    public IoSession connect(SocketAddress address, IoHandler handler) throws IOException {
        return this.connect(address, null, handler);
    }

    public IoSession connect(SocketAddress address, int timeout, IoHandler handler) throws IOException {
        return this.connect(address, null, handler);
    }

    public IoSession connect(SocketAddress address, SocketAddress localAddress, int timeout, IoHandler handler) throws IOException {
        return this.connect(address, localAddress, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession connect(SocketAddress address, SocketAddress localAddress, IoHandler handler) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        DatagramChannel ch = DatagramChannel.open();
        boolean initialized = false;
        try {
            ch.socket().setReuseAddress(true);
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.connect(address);
            ch.configureBlocking(false);
            initialized = true;
        }
        finally {
            if (!initialized) {
                ch.close();
            }
        }
        RegistrationRequest request = new RegistrationRequest(ch, handler);
        Object object = this;
        synchronized (object) {
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(request);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            ExceptionUtil.throwException(request.exception);
        }
        return request.session;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSession(DatagramSession session) {
        DatagramConnector datagramConnector = this;
        synchronized (datagramConnector) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                return;
            }
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                this.cancelQueue.push(session);
            }
        }
        this.selector.wakeup();
    }

    void flushSession(DatagramSession session) {
        this.scheduleFlush(session);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(DatagramSession session) {
        Queue queue = this.flushingSessions;
        synchronized (queue) {
            this.flushingSessions.push(session);
        }
    }

    private void processReadySessions(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            it.remove();
            DatagramSession session = (DatagramSession)key.attachment();
            if (key.isReadable()) {
                this.readSession(session);
            }
            if (!key.isWritable()) continue;
            this.scheduleFlush(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramSession session) {
        ByteBuffer readBuf = ByteBuffer.allocate(2048);
        try {
            int readBytes = session.getChannel().read(readBuf.buf());
            if (readBytes > 0) {
                readBuf.flip();
                ByteBuffer newBuf = ByteBuffer.allocate(readBuf.limit());
                newBuf.put(readBuf);
                newBuf.flip();
                session.increaseReadBytes(readBytes);
                this.filters.dataRead(session, newBuf);
            }
        }
        catch (IOException e) {
            this.filters.exceptionCaught(session, e);
        }
        finally {
            readBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            DatagramSession session;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                session = (DatagramSession)this.flushingSessions.pop();
            }
            if (session == null) break;
            try {
                this.flush(session);
            }
            catch (IOException e) {
                session.getManagerFilterChain().exceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(DatagramSession session) throws IOException {
        DatagramChannel ch = session.getChannel();
        Queue writeBufferQueue = session.getWriteBufferQueue();
        Queue writeMarkerQueue = session.getWriteMarkerQueue();
        while (true) {
            Object marker;
            ByteBuffer buf;
            Queue queue = writeBufferQueue;
            synchronized (queue) {
                buf = (ByteBuffer)writeBufferQueue.first();
                marker = writeMarkerQueue.first();
            }
            if (buf == null) break;
            if (buf.remaining() == 0) {
                queue = writeBufferQueue;
                synchronized (queue) {
                    writeBufferQueue.pop();
                    writeMarkerQueue.pop();
                }
                try {
                    buf.release();
                }
                catch (IllegalStateException e) {
                    session.getManagerFilterChain().exceptionCaught(session, e);
                }
                session.increaseWrittenWriteRequests();
                session.getManagerFilterChain().dataWritten(session, marker);
                continue;
            }
            int writtenBytes = ch.write(buf.buf());
            SelectionKey key = session.getSelectionKey();
            if (writtenBytes == 0) {
                key.interestOps(key.interestOps() | 4);
                continue;
            }
            if (writtenBytes <= 0) continue;
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            Queue queue2 = writeBufferQueue;
            synchronized (queue2) {
                writeBufferQueue.pop();
                writeMarkerQueue.pop();
            }
            session.increaseWrittenBytes(writtenBytes);
            session.increaseWrittenWriteRequests();
            session.getManagerFilterChain().dataWritten(session, marker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            Object key;
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            DatagramSession session = new DatagramSession(this.filters, req.channel, req.handler);
            try {
                req.handler.sessionCreated(session);
                key = req.channel.register(this.selector, 1, session);
                session.setSelectionKey((SelectionKey)key);
                continue;
            }
            catch (Throwable t) {
                req.exception = t;
                continue;
            }
            finally {
                key = req;
                synchronized (key) {
                    req.done = true;
                    req.session = session;
                    req.notify();
                }
                if (req.exception == null) continue;
                try {
                    req.channel.close();
                }
                catch (IOException e) {
                    this.exceptionMonitor.exceptionCaught(this, e);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            DatagramSession session;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                session = (DatagramSession)this.cancelQueue.pop();
            }
            if (session == null) break;
            SelectionKey key = session.getSelectionKey();
            DatagramChannel ch = (DatagramChannel)key.channel();
            try {
                ch.close();
            }
            catch (IOException e) {
                this.exceptionMonitor.exceptionCaught(this, e);
            }
            session.notifyClose();
            key.cancel();
            this.selector.wakeup();
        }
    }

    public IoFilterChain getFilterChain() {
        return this.filters;
    }

    private static class RegistrationRequest {
        private final DatagramChannel channel;
        private final IoHandler handler;
        private boolean done;
        private DatagramSession session;
        private Throwable exception;

        private RegistrationRequest(DatagramChannel channel, IoHandler handler) {
            this.channel = channel;
            this.handler = handler;
        }
    }

    private class Worker
    extends Thread {
        public Worker() {
            super("DatagramAcceptor-" + DatagramConnector.this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = DatagramConnector.this.selector.select();
                        DatagramConnector.this.registerNew();
                        if (nKeys > 0) {
                            DatagramConnector.this.processReadySessions(DatagramConnector.this.selector.selectedKeys());
                        }
                        DatagramConnector.this.flushSessions();
                        DatagramConnector.this.cancelKeys();
                    } while (!DatagramConnector.this.selector.keys().isEmpty());
                    DatagramConnector datagramConnector = DatagramConnector.this;
                    synchronized (datagramConnector) {
                        if (DatagramConnector.this.selector.keys().isEmpty() && DatagramConnector.this.registerQueue.isEmpty() && DatagramConnector.this.cancelQueue.isEmpty()) {
                            DatagramConnector.this.worker = null;
                            try {
                                DatagramConnector.this.selector.close();
                            }
                            catch (IOException e) {
                                DatagramConnector.this.exceptionMonitor.exceptionCaught(DatagramConnector.this, e);
                            }
                            finally {
                                DatagramConnector.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    DatagramConnector.this.exceptionMonitor.exceptionCaught(DatagramConnector.this, e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

