/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.filter;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.io.IoFilter;
import org.apache.mina.io.IoSession;
import org.apache.mina.util.SessionLog;

public class IoLoggingFilter
implements IoFilter {
    public static final String PREFIX = SessionLog.PREFIX;
    public static final String LOGGER = SessionLog.LOGGER;

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
        SessionLog.info(session, "OPENED");
        nextFilter.sessionOpened(session);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
        SessionLog.info(session, "CLOSED");
        nextFilter.sessionClosed(session);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
        SessionLog.info(session, "IDLE: " + status);
        nextFilter.sessionIdle(session, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        SessionLog.error(session, "EXCEPTION: ", cause);
        nextFilter.exceptionCaught(session, cause);
    }

    public void dataRead(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf) {
        SessionLog.info(session, "READ: " + buf.getHexDump());
        nextFilter.dataRead(session, buf);
    }

    public void dataWritten(IoFilter.NextFilter nextFilter, IoSession session, Object marker) {
        SessionLog.info(session, "WRITTEN: " + marker);
        nextFilter.dataWritten(session, marker);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf, Object marker) {
        SessionLog.info(session, "WRITE: " + marker + ", " + buf.getHexDump());
        nextFilter.filterWrite(session, buf, marker);
    }
}

