/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.httpserver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.handler.StreamIoHandler;

public class HttpProtocolHandler
extends StreamIoHandler {
    protected void processStreamIo(IoSession session, InputStream in, OutputStream out) {
        new Worker(in, out).start();
    }

    private static class Worker
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public Worker(InputStream in, OutputStream out) {
            this.setDaemon(true);
            this.in = in;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TreeMap<String, String> headers = new TreeMap<String, String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(this.in));
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.out)));
            try {
                String line;
                String url = in.readLine().split(" ")[1];
                while ((line = in.readLine()) != null && !line.equals("")) {
                    String[] tokens = line.split(": ");
                    headers.put(tokens[0], tokens[1]);
                }
                out.println("HTTP/1.0 200 OK");
                out.println("Content-Type: text/html");
                out.println("Server: MINA Example");
                out.println();
                out.println("<html><head></head><body>");
                out.println("<h3>Request Summary for: " + url + "</h3>");
                out.println("<table border=\"1\"><tr><th>Key</th><th>Value</th></tr>");
                Iterator it = headers.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    out.println("<tr><td>" + e.getKey() + "</td><td>" + e.getValue() + "</td></tr>");
                }
                out.println("</table>");
                out.println("</body></html>");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                out.flush();
                out.close();
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

