/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.echoserver;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.io.IoHandlerAdapter;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.socket.SocketSessionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoProtocolHandler
extends IoHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger((Class)EchoProtocolHandler.class);

    public void sessionCreated(IoSession session) {
        SessionConfig cfg = session.getConfig();
        if (cfg instanceof SocketSessionConfig) {
            ((SocketSessionConfig)cfg).setSessionReceiveBufferSize(2048);
        }
        cfg.setIdleTime(IdleStatus.BOTH_IDLE, 10);
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        log.info("*** IDLE #" + session.getIdleCount(IdleStatus.BOTH_IDLE) + " ***");
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }

    public void dataRead(IoSession session, ByteBuffer rb) {
        ByteBuffer wb = ByteBuffer.allocate(rb.remaining());
        wb.put(rb);
        wb.flip();
        session.write(wb, null);
    }
}

