/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.socket;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.io.WriteTimeoutException;
import org.apache.mina.io.socket.SocketSession;
import org.apache.mina.io.socket.SocketSessionConfig;
import org.apache.mina.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketIoProcessor {
    private static final Logger log;
    private static final SocketIoProcessor instance;
    private final Selector selector;
    private final Queue newSessions = new Queue();
    private final Queue removingSessions = new Queue();
    private final Queue flushingSessions = new Queue();
    private final Queue readableSessions = new Queue();
    private Worker worker;
    private long lastIdleCheckTime = System.currentTimeMillis();

    private SocketIoProcessor() throws IOException {
        this.selector = Selector.open();
    }

    static SocketIoProcessor getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSession(SocketSession session) {
        SocketIoProcessor socketIoProcessor = this;
        synchronized (socketIoProcessor) {
            Queue queue = this.newSessions;
            synchronized (queue) {
                this.newSessions.push(session);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
    }

    void removeSession(SocketSession session) {
        this.scheduleRemove(session);
        this.startupWorker();
        this.selector.wakeup();
    }

    private synchronized void startupWorker() {
        if (this.worker == null) {
            this.worker = new Worker();
            this.worker.start();
        }
    }

    void flushSession(SocketSession session) {
        this.scheduleFlush(session);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReadableSession(SocketSession session) {
        Queue queue = this.readableSessions;
        synchronized (queue) {
            this.readableSessions.push(session);
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSessions() {
        if (this.newSessions.isEmpty()) {
            return;
        }
        while (true) {
            boolean registered;
            SocketSession session;
            Queue queue = this.newSessions;
            synchronized (queue) {
                session = (SocketSession)this.newSessions.pop();
            }
            if (session == null) break;
            SocketChannel ch = session.getChannel();
            try {
                ch.configureBlocking(false);
                session.setSelectionKey(ch.register(this.selector, 1, session));
                registered = true;
            }
            catch (IOException e) {
                registered = false;
                session.getManagerFilterChain().exceptionCaught(session, e);
            }
            if (!registered) continue;
            session.getManagerFilterChain().sessionOpened(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void removeSessions() {
        if (this.removingSessions.isEmpty()) {
            return;
        }
        while (true) {
            Queue queue = this.removingSessions;
            // MONITORENTER : queue
            SocketSession session = (SocketSession)this.removingSessions.pop();
            // MONITOREXIT : queue
            if (session == null) {
                return;
            }
            SocketChannel ch = session.getChannel();
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleRemove(session);
                return;
            }
            if (!key.isValid()) continue;
            try {
                key.cancel();
                ch.close();
                continue;
            }
            catch (IOException e) {
                session.getManagerFilterChain().exceptionCaught(session, e);
                continue;
            }
            finally {
                this.releaseWriteBuffers(session);
                session.getManagerFilterChain().sessionClosed(session);
                session.notifyClose();
                continue;
            }
            break;
        }
    }

    private void processSessions(Set selectedKeys) {
        Iterator it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            SocketSession session = (SocketSession)key.attachment();
            if (key.isReadable()) {
                this.read(session);
            }
            if (!key.isWritable()) continue;
            this.scheduleFlush(session);
        }
        selectedKeys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(SocketSession session) {
        ByteBuffer buf = ByteBuffer.allocate(((SocketSessionConfig)session.getConfig()).getSessionReceiveBufferSize());
        SocketChannel ch = session.getChannel();
        try {
            int ret;
            int readBytes = 0;
            buf.clear();
            try {
                while ((ret = ch.read(buf.buf())) > 0) {
                    readBytes += ret;
                }
            }
            finally {
                buf.flip();
            }
            session.increaseReadBytes(readBytes);
            session.resetIdleCount(IdleStatus.BOTH_IDLE);
            session.resetIdleCount(IdleStatus.READER_IDLE);
            if (readBytes > 0) {
                ByteBuffer newBuf = ByteBuffer.allocate(readBytes);
                newBuf.put(buf);
                newBuf.flip();
                session.getManagerFilterChain().dataRead(session, newBuf);
            }
            if (ret < 0) {
                this.scheduleRemove(session);
            }
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                this.scheduleRemove(session);
            }
            session.getManagerFilterChain().exceptionCaught(session, e);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRemove(SocketSession session) {
        Queue queue = this.removingSessions;
        synchronized (queue) {
            this.removingSessions.push(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(SocketSession session) {
        Queue queue = this.flushingSessions;
        synchronized (queue) {
            this.flushingSessions.push(session);
        }
    }

    private void notifyIdleSessions() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastIdleCheckTime >= 1000L) {
            this.lastIdleCheckTime = currentTime;
            Set<SelectionKey> keys = this.selector.keys();
            if (keys != null) {
                Iterator<SelectionKey> it = keys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    SocketSession session = (SocketSession)key.attachment();
                    this.notifyIdleSession(session, currentTime);
                }
            }
        }
    }

    private void notifyIdleSession(SocketSession session, long currentTime) {
        SessionConfig config = session.getConfig();
        this.notifyIdleSession0(session, currentTime, config.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(session.getLastIoTime(), session.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        this.notifyIdleSession0(session, currentTime, config.getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(session.getLastReadTime(), session.getLastIdleTime(IdleStatus.READER_IDLE)));
        this.notifyIdleSession0(session, currentTime, config.getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(session.getLastWriteTime(), session.getLastIdleTime(IdleStatus.WRITER_IDLE)));
        this.notifyWriteTimeoutSession(session, currentTime, config.getWriteTimeoutInMillis(), session.getLastWriteTime());
    }

    private void notifyIdleSession0(SocketSession session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.increaseIdleCount(status);
            session.getManagerFilterChain().sessionIdle(session, status);
        }
    }

    private void notifyWriteTimeoutSession(SocketSession session, long currentTime, long writeTimeout, long lastIoTime) {
        SelectionKey key = session.getSelectionKey();
        if (writeTimeout > 0L && currentTime - lastIoTime >= writeTimeout && key != null && key.isValid() && (key.interestOps() & 4) != 0) {
            session.getManagerFilterChain().exceptionCaught(session, new WriteTimeoutException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            SocketSession session;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                session = (SocketSession)this.flushingSessions.pop();
            }
            if (session == null) break;
            if (!session.isConnected()) {
                this.releaseWriteBuffers(session);
                continue;
            }
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleFlush(session);
                break;
            }
            if (!key.isValid()) continue;
            try {
                this.flush(session);
            }
            catch (IOException e) {
                this.scheduleRemove(session);
                session.getManagerFilterChain().exceptionCaught(session, e);
            }
        }
    }

    private void releaseWriteBuffers(SocketSession session) {
        ByteBuffer buf;
        Queue writeBufferQueue = session.getWriteBufferQueue();
        session.getWriteMarkerQueue().clear();
        while ((buf = (ByteBuffer)writeBufferQueue.pop()) != null) {
            try {
                buf.release();
            }
            catch (IllegalStateException e) {
                session.getManagerFilterChain().exceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(SocketSession session) throws IOException {
        block11: {
            SelectionKey key = session.getSelectionKey();
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            SocketChannel ch = session.getChannel();
            Queue writeBufferQueue = session.getWriteBufferQueue();
            Queue writeMarkerQueue = session.getWriteMarkerQueue();
            while (true) {
                Object marker;
                ByteBuffer buf;
                Queue queue = writeBufferQueue;
                synchronized (queue) {
                    buf = (ByteBuffer)writeBufferQueue.first();
                    marker = writeMarkerQueue.first();
                }
                if (buf == null) break block11;
                if (buf.remaining() == 0) {
                    queue = writeBufferQueue;
                    synchronized (queue) {
                        writeBufferQueue.pop();
                        writeMarkerQueue.pop();
                    }
                    try {
                        buf.release();
                    }
                    catch (IllegalStateException e) {
                        session.getManagerFilterChain().exceptionCaught(session, e);
                    }
                    session.increaseWrittenWriteRequests();
                    session.getManagerFilterChain().dataWritten(session, marker);
                    continue;
                }
                int writtenBytes = ch.write(buf.buf());
                if (writtenBytes > 0) {
                    session.increaseWrittenBytes(writtenBytes);
                    session.resetIdleCount(IdleStatus.BOTH_IDLE);
                    session.resetIdleCount(IdleStatus.WRITER_IDLE);
                }
                if (buf.hasRemaining()) break;
            }
            key.interestOps(key.interestOps() | 4);
        }
    }

    static {
        SocketIoProcessor tmp;
        log = LoggerFactory.getLogger((Class)SocketIoProcessor.class);
        try {
            tmp = new SocketIoProcessor();
        }
        catch (IOException e) {
            InternalError error = new InternalError("Failed to open selector.");
            error.initCause(e);
            throw error;
        }
        instance = tmp;
    }

    private class Worker
    extends Thread {
        public Worker() {
            super("SocketIoProcessor");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = SocketIoProcessor.this.selector.select(1000L);
                        SocketIoProcessor.this.addSessions();
                        if (nKeys > 0) {
                            SocketIoProcessor.this.processSessions(SocketIoProcessor.this.selector.selectedKeys());
                        }
                        SocketIoProcessor.this.flushSessions();
                        SocketIoProcessor.this.removeSessions();
                        SocketIoProcessor.this.notifyIdleSessions();
                    } while (!SocketIoProcessor.this.selector.keys().isEmpty());
                    SocketIoProcessor socketIoProcessor = SocketIoProcessor.this;
                    synchronized (socketIoProcessor) {
                        if (SocketIoProcessor.this.selector.keys().isEmpty() && SocketIoProcessor.this.newSessions.isEmpty()) {
                            SocketIoProcessor.this.worker = null;
                            break;
                        }
                        continue;
                    }
                }
                catch (Throwable t) {
                    log.warn("Unexpected exception.", t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

