/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.vmpipe;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.protocol.vmpipe.VmPipeSession;

class VmPipeIdleStatusChecker {
    static final VmPipeIdleStatusChecker INSTANCE = new VmPipeIdleStatusChecker();
    private final Map sessions = new IdentityHashMap();
    private final Worker worker = new Worker();

    private VmPipeIdleStatusChecker() {
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSession(VmPipeSession session) {
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.put(session, session);
        }
    }

    private void notifyIdleSession(VmPipeSession session, long currentTime) {
        SessionConfig config = session.getConfig();
        this.notifyIdleSession0(session, currentTime, config.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(session.getLastIoTime(), session.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        this.notifyIdleSession0(session, currentTime, config.getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(session.getLastReadTime(), session.getLastIdleTime(IdleStatus.READER_IDLE)));
        this.notifyIdleSession0(session, currentTime, config.getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(session.getLastWriteTime(), session.getLastIdleTime(IdleStatus.WRITER_IDLE)));
    }

    private void notifyIdleSession0(VmPipeSession session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.increaseIdleCount(status);
            session.getManagerFilterChain().sessionIdle(session, status);
        }
    }

    private class Worker
    extends Thread {
        private Worker() {
            super("VmPipeIdleStatusChecker");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long currentTime = System.currentTimeMillis();
                Map map = VmPipeIdleStatusChecker.this.sessions;
                synchronized (map) {
                    Iterator it = VmPipeIdleStatusChecker.this.sessions.keySet().iterator();
                    while (it.hasNext()) {
                        VmPipeSession session = (VmPipeSession)it.next();
                        if (!session.isConnected()) {
                            it.remove();
                            continue;
                        }
                        VmPipeIdleStatusChecker.this.notifyIdleSession(session, currentTime);
                    }
                }
            }
        }
    }
}

