/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.mina.common.BufferDataException;
import org.apache.mina.common.support.ByteBufferHexDumper;
import org.apache.mina.util.Stack;

public abstract class ByteBuffer
implements Comparable {
    private static final int MINIMUM_CAPACITY = 1;
    private static final Stack containerStack = new Stack();
    private static final Stack[] heapBufferStacks = new Stack[]{new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack()};
    private static final Stack[] directBufferStacks = new Stack[]{new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack()};

    public static ByteBuffer allocate(int capacity) {
        try {
            return ByteBuffer.allocate(capacity, true);
        }
        catch (OutOfMemoryError e) {
            return ByteBuffer.allocate(capacity, false);
        }
    }

    public static ByteBuffer allocate(int capacity, boolean direct) {
        java.nio.ByteBuffer nioBuffer = ByteBuffer.allocate0(capacity, direct);
        DefaultByteBuffer buf = ByteBuffer.allocateContainer();
        buf.init(nioBuffer);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DefaultByteBuffer allocateContainer() {
        DefaultByteBuffer buf;
        Stack stack = containerStack;
        synchronized (stack) {
            buf = (DefaultByteBuffer)containerStack.pop();
        }
        if (buf == null) {
            buf = new DefaultByteBuffer();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static java.nio.ByteBuffer allocate0(int capacity, boolean direct) {
        java.nio.ByteBuffer buf;
        Stack stack;
        Stack[] bufferStacks = direct ? directBufferStacks : heapBufferStacks;
        int idx = ByteBuffer.getBufferStackIndex(bufferStacks, capacity);
        Stack stack2 = stack = bufferStacks[idx];
        synchronized (stack2) {
            buf = (java.nio.ByteBuffer)stack.pop();
        }
        if (buf == null) {
            buf = direct ? java.nio.ByteBuffer.allocateDirect(1 << idx) : java.nio.ByteBuffer.allocate(1 << idx);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release0(java.nio.ByteBuffer buf) {
        Stack stack;
        Stack[] bufferStacks = buf.isDirect() ? directBufferStacks : heapBufferStacks;
        Stack stack2 = stack = bufferStacks[ByteBuffer.getBufferStackIndex(bufferStacks, buf.capacity())];
        synchronized (stack2) {
            stack.push(buf);
        }
    }

    public static ByteBuffer wrap(java.nio.ByteBuffer nioBuffer) {
        DefaultByteBuffer buf = ByteBuffer.allocateContainer();
        buf.init(nioBuffer);
        buf.setPooled(false);
        return buf;
    }

    public static ByteBuffer wrap(byte[] byteArray) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byteArray));
    }

    public static ByteBuffer wrap(byte[] byteArray, int offset, int length) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byteArray, offset, length));
    }

    private static int getBufferStackIndex(Stack[] bufferStacks, int size) {
        int stackIdx = 0;
        for (int targetSize = 1; size > targetSize; targetSize <<= 1) {
            if (++stackIdx < bufferStacks.length) continue;
            throw new IllegalArgumentException("Buffer size is too big: " + size);
        }
        return stackIdx;
    }

    protected ByteBuffer() {
    }

    public abstract void acquire();

    public abstract void release();

    public abstract java.nio.ByteBuffer buf();

    public abstract boolean isDirect();

    public abstract int capacity();

    public abstract boolean isAutoExpand();

    public abstract ByteBuffer setAutoExpand(boolean var1);

    public abstract ByteBuffer expand(int var1);

    public abstract ByteBuffer expand(int var1, int var2);

    public abstract boolean isPooled();

    public abstract void setPooled(boolean var1);

    public abstract int position();

    public abstract ByteBuffer position(int var1);

    public abstract int limit();

    public abstract ByteBuffer limit(int var1);

    public abstract ByteBuffer mark();

    public abstract ByteBuffer reset();

    public abstract ByteBuffer clear();

    public ByteBuffer sweep() {
        this.clear();
        return this.fillAndReset(this.remaining());
    }

    public ByteBuffer sweep(byte value) {
        this.clear();
        return this.fillAndReset(value, this.remaining());
    }

    public abstract ByteBuffer flip();

    public abstract ByteBuffer rewind();

    public abstract int remaining();

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public abstract byte get();

    public short getUnsigned() {
        return (short)(this.get() & 0xFF);
    }

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public short getUnsigned(int index) {
        return (short)(this.get(index) & 0xFF);
    }

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer get(byte[] var1, int var2, int var3);

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public abstract ByteBuffer put(java.nio.ByteBuffer var1);

    public ByteBuffer put(ByteBuffer src) {
        return this.put(src.buf());
    }

    public abstract ByteBuffer put(byte[] var1, int var2, int var3);

    public ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public abstract ByteBuffer compact();

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.isDirect()) {
            buf.append("DirectBuffer");
        } else {
            buf.append("HeapBuffer");
        }
        buf.append("[pos=");
        buf.append(this.position());
        buf.append(" lim=");
        buf.append(this.limit());
        buf.append(" cap=");
        buf.append(this.capacity());
        buf.append(": ");
        buf.append(this.getHexDump());
        buf.append(']');
        return buf.toString();
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer that = (ByteBuffer)o;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public int compareTo(Object o) {
        ByteBuffer that = (ByteBuffer)o;
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    public abstract ByteOrder order();

    public abstract ByteBuffer order(ByteOrder var1);

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract CharBuffer asCharBuffer();

    public abstract short getShort();

    public int getUnsignedShort() {
        return this.getShort() & 0xFFFF;
    }

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract IntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract LongBuffer asLongBuffer();

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract FloatBuffer asFloatBuffer();

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public abstract DoubleBuffer asDoubleBuffer();

    public InputStream asInputStream() {
        return new InputStream(){

            public int available() throws IOException {
                return ByteBuffer.this.remaining();
            }

            public synchronized void mark(int readlimit) {
                ByteBuffer.this.mark();
            }

            public boolean markSupported() {
                return true;
            }

            public int read() throws IOException {
                if (ByteBuffer.this.hasRemaining()) {
                    return ByteBuffer.this.get() & 0xFF;
                }
                return -1;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int remaining = ByteBuffer.this.remaining();
                if (remaining > 0) {
                    int readBytes = Math.min(remaining, len);
                    ByteBuffer.this.get(b, off, readBytes);
                    return readBytes;
                }
                return -1;
            }

            public synchronized void reset() throws IOException {
                ByteBuffer.this.reset();
            }

            public long skip(long n) throws IOException {
                int bytes = n > Integer.MAX_VALUE ? ByteBuffer.this.remaining() : Math.min(ByteBuffer.this.remaining(), (int)n);
                ByteBuffer.this.skip(bytes);
                return bytes;
            }
        };
    }

    public OutputStream asOutputStream() {
        return new OutputStream(){

            public void write(byte[] b, int off, int len) throws IOException {
                ByteBuffer.this.put(b, off, len);
            }

            public void write(int b) throws IOException {
                ByteBuffer.this.put((byte)b);
            }
        };
    }

    public String getHexDump() {
        return ByteBufferHexDumper.getHexdump(this);
    }

    public String getString(CharsetDecoder decoder) throws CharacterCodingException {
        CoderResult cr;
        int end;
        if (!this.hasRemaining()) {
            return "";
        }
        boolean utf16 = decoder.charset().name().startsWith("UTF-16");
        int oldPos = this.position();
        int oldLimit = this.limit();
        if (!utf16) {
            while (this.hasRemaining() && this.get() != 0) {
            }
            end = this.position();
            if (end == oldLimit) {
                this.limit(end);
            } else {
                this.limit(end - 1);
            }
        } else {
            while (this.remaining() >= 2 && (this.get() != 0 || this.get() != 0)) {
            }
            end = this.position();
            if (end == oldLimit || end == oldLimit - 1) {
                this.limit(end);
            } else {
                this.limit(end - 2);
            }
        }
        this.position(oldPos);
        if (!this.hasRemaining()) {
            this.limit(oldLimit);
            this.position(end);
            return "";
        }
        decoder.reset();
        int expectedLength = (int)((float)this.remaining() * decoder.averageCharsPerByte()) + 1;
        CharBuffer out = CharBuffer.allocate(expectedLength);
        while (!(cr = this.hasRemaining() ? decoder.decode(this.buf(), out, true) : decoder.flush(out)).isUnderflow()) {
            if (cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            cr.throwException();
        }
        this.limit(oldLimit);
        this.position(end);
        return out.flip().toString();
    }

    public String getString(int fieldSize, CharsetDecoder decoder) throws CharacterCodingException {
        CoderResult cr;
        int i;
        int end;
        ByteBuffer.checkFieldSize(fieldSize);
        if (fieldSize == 0) {
            return "";
        }
        if (!this.hasRemaining()) {
            return "";
        }
        boolean utf16 = decoder.charset().name().startsWith("UTF-16");
        if (utf16 && (fieldSize & 1) != 0) {
            throw new IllegalArgumentException("fieldSize is not even.");
        }
        int oldPos = this.position();
        int oldLimit = this.limit();
        if (oldLimit < (end = this.position() + fieldSize)) {
            throw new BufferUnderflowException();
        }
        if (!utf16) {
            for (i = 0; i < fieldSize && this.get() != 0; ++i) {
            }
            if (i == fieldSize) {
                this.limit(end);
            } else {
                this.limit(this.position() - 1);
            }
        } else {
            for (i = 0; i < fieldSize && (this.get() != 0 || this.get() != 0); i += 2) {
            }
            if (i == fieldSize) {
                this.limit(end);
            } else {
                this.limit(this.position() - 2);
            }
        }
        this.position(oldPos);
        if (!this.hasRemaining()) {
            this.limit(oldLimit);
            this.position(end);
            return "";
        }
        decoder.reset();
        int expectedLength = (int)((float)this.remaining() * decoder.averageCharsPerByte()) + 1;
        CharBuffer out = CharBuffer.allocate(expectedLength);
        while (!(cr = this.hasRemaining() ? decoder.decode(this.buf(), out, true) : decoder.flush(out)).isUnderflow()) {
            if (cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            cr.throwException();
        }
        this.limit(oldLimit);
        this.position(end);
        return out.flip().toString();
    }

    public ByteBuffer putString(CharSequence val, CharsetEncoder encoder) throws CharacterCodingException {
        CoderResult cr;
        if (val.length() == 0) {
            return this;
        }
        CharBuffer in = CharBuffer.wrap(val);
        int expectedLength = (int)((float)in.remaining() * encoder.averageBytesPerChar()) + 1;
        encoder.reset();
        while (!(cr = in.hasRemaining() ? encoder.encode(in, this.buf(), true) : encoder.flush(this.buf())).isUnderflow()) {
            if (cr.isOverflow() && this.isAutoExpand()) {
                this.autoExpand(expectedLength);
                continue;
            }
            cr.throwException();
        }
        return this;
    }

    public ByteBuffer putString(CharSequence val, int fieldSize, CharsetEncoder encoder) throws CharacterCodingException {
        CoderResult cr;
        int end;
        ByteBuffer.checkFieldSize(fieldSize);
        if (fieldSize == 0) {
            return this;
        }
        this.autoExpand(fieldSize);
        boolean utf16 = encoder.charset().name().startsWith("UTF-16");
        if (utf16 && (fieldSize & 1) != 0) {
            throw new IllegalArgumentException("fieldSize is not even.");
        }
        int oldLimit = this.limit();
        if (oldLimit < (end = this.position() + fieldSize)) {
            throw new BufferOverflowException();
        }
        if (val.length() == 0) {
            if (!utf16) {
                this.put((byte)0);
            } else {
                this.put((byte)0);
                this.put((byte)0);
            }
            this.position(end);
            return this;
        }
        CharBuffer in = CharBuffer.wrap(val);
        this.limit(end);
        encoder.reset();
        while (!(cr = in.hasRemaining() ? encoder.encode(in, this.buf(), true) : encoder.flush(this.buf())).isUnderflow() && !cr.isOverflow()) {
            cr.throwException();
        }
        this.limit(oldLimit);
        if (this.position() < end) {
            if (!utf16) {
                this.put((byte)0);
            } else {
                this.put((byte)0);
                this.put((byte)0);
            }
        }
        this.position(end);
        return this;
    }

    public String getPrefixedString(CharsetDecoder decoder) throws CharacterCodingException {
        return this.getPrefixedString(2, decoder);
    }

    public String getPrefixedString(int prefixLength, CharsetDecoder decoder) throws CharacterCodingException {
        CoderResult cr;
        int end;
        if (!this.prefixedDataAvailable(prefixLength)) {
            throw new BufferUnderflowException();
        }
        int fieldSize = 0;
        switch (prefixLength) {
            case 1: {
                fieldSize = this.getUnsigned();
                break;
            }
            case 2: {
                fieldSize = this.getUnsignedShort();
                break;
            }
            case 4: {
                fieldSize = this.getInt();
            }
        }
        if (fieldSize == 0) {
            return "";
        }
        boolean utf16 = decoder.charset().name().startsWith("UTF-16");
        if (utf16 && (fieldSize & 1) != 0) {
            throw new BufferDataException("fieldSize is not even for a UTF-16 string.");
        }
        int oldLimit = this.limit();
        if (oldLimit < (end = this.position() + fieldSize)) {
            throw new BufferUnderflowException();
        }
        this.limit(end);
        decoder.reset();
        int expectedLength = (int)((float)this.remaining() * decoder.averageCharsPerByte()) + 1;
        CharBuffer out = CharBuffer.allocate(expectedLength);
        while (!(cr = this.hasRemaining() ? decoder.decode(this.buf(), out, true) : decoder.flush(out)).isUnderflow()) {
            if (cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            cr.throwException();
        }
        this.limit(oldLimit);
        this.position(end);
        return out.flip().toString();
    }

    public ByteBuffer putPrefixedString(CharSequence in, CharsetEncoder encoder) throws CharacterCodingException {
        return this.putPrefixedString(in, 2, 0, encoder);
    }

    public ByteBuffer putPrefixedString(CharSequence in, int prefixLength, CharsetEncoder encoder) throws CharacterCodingException {
        return this.putPrefixedString(in, prefixLength, 0, encoder);
    }

    public ByteBuffer putPrefixedString(CharSequence in, int prefixLength, int padding, CharsetEncoder encoder) throws CharacterCodingException {
        return this.putPrefixedString(in, prefixLength, padding, (byte)0, encoder);
    }

    public ByteBuffer putPrefixedString(CharSequence val, int prefixLength, int padding, byte padValue, CharsetEncoder encoder) throws CharacterCodingException {
        int padMask;
        int maxLength;
        switch (prefixLength) {
            case 1: {
                maxLength = 255;
                break;
            }
            case 2: {
                maxLength = 65535;
                break;
            }
            case 4: {
                maxLength = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("prefixLength: " + prefixLength);
            }
        }
        if (val.length() > maxLength) {
            throw new IllegalArgumentException("The specified string is too long.");
        }
        if (val.length() == 0) {
            switch (prefixLength) {
                case 1: {
                    this.put((byte)0);
                    break;
                }
                case 2: {
                    this.putShort((short)0);
                    break;
                }
                case 4: {
                    this.putInt(0);
                }
            }
            return this;
        }
        switch (padding) {
            case 0: 
            case 1: {
                padMask = 0;
                break;
            }
            case 2: {
                padMask = 1;
                break;
            }
            case 4: {
                padMask = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("padding: " + padding);
            }
        }
        CharBuffer in = CharBuffer.wrap(val);
        int expectedLength = (int)((float)in.remaining() * encoder.averageBytesPerChar()) + 1;
        this.skip(prefixLength);
        int oldPos = this.position();
        encoder.reset();
        while (true) {
            CoderResult cr = in.hasRemaining() ? encoder.encode(in, this.buf(), true) : encoder.flush(this.buf());
            if (this.position() - oldPos > maxLength) {
                throw new IllegalArgumentException("The specified string is too long.");
            }
            if (cr.isUnderflow()) break;
            if (cr.isOverflow() && this.isAutoExpand()) {
                this.autoExpand(expectedLength);
                continue;
            }
            cr.throwException();
        }
        this.fill(padValue, padding - (this.position() - oldPos & padMask));
        int length = this.position() - oldPos;
        switch (prefixLength) {
            case 1: {
                this.put(oldPos - 1, (byte)length);
                break;
            }
            case 2: {
                this.putShort(oldPos - 2, (short)length);
                break;
            }
            case 4: {
                this.putInt(oldPos - 4, length);
            }
        }
        return this;
    }

    public Object getObject() throws ClassNotFoundException {
        return this.getObject(Thread.currentThread().getContextClassLoader());
    }

    public Object getObject(final ClassLoader classLoader) throws ClassNotFoundException {
        if (!this.prefixedDataAvailable(4)) {
            throw new BufferUnderflowException();
        }
        int length = this.getInt();
        if (length <= 4) {
            throw new BufferDataException("Object length should be greater than 4: " + length);
        }
        int oldLimit = this.limit();
        this.limit(this.position() + length);
        try {
            ObjectInputStream in = new ObjectInputStream(this.asInputStream()){

                protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                    String className = this.readUTF();
                    Class<?> clazz = Class.forName(className, true, classLoader);
                    ObjectStreamClass descriptor = ObjectStreamClass.lookup(clazz);
                    return descriptor;
                }
            };
            Object object = in.readObject();
            return object;
        }
        catch (IOException e) {
            throw new BufferDataException(e);
        }
        finally {
            this.limit(oldLimit);
        }
    }

    public ByteBuffer putObject(Object o) {
        int oldPos = this.position();
        this.skip(4);
        try {
            ObjectOutputStream out = new ObjectOutputStream(this.asOutputStream()){

                protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
                    this.writeUTF(desc.getName());
                }
            };
            out.writeObject(o);
            out.flush();
        }
        catch (IOException e) {
            throw new BufferDataException(e);
        }
        int newPos = this.position();
        this.position(oldPos);
        this.putInt(newPos - oldPos - 4);
        this.position(newPos);
        return this;
    }

    public boolean prefixedDataAvailable(int prefixLength) {
        return this.prefixedDataAvailable(prefixLength, Integer.MAX_VALUE);
    }

    public boolean prefixedDataAvailable(int prefixLength, int maxDataLength) {
        int dataLength;
        if (this.remaining() < prefixLength) {
            return false;
        }
        switch (prefixLength) {
            case 1: {
                dataLength = this.getUnsigned(this.position());
                break;
            }
            case 2: {
                dataLength = this.getUnsignedShort(this.position());
                break;
            }
            case 4: {
                dataLength = this.getInt(this.position());
                break;
            }
            default: {
                throw new IllegalArgumentException("prefixLength: " + prefixLength);
            }
        }
        if (dataLength < 0 || dataLength > maxDataLength) {
            throw new BufferDataException("dataLength: " + dataLength);
        }
        return this.remaining() - prefixLength >= dataLength;
    }

    public ByteBuffer skip(int size) {
        this.autoExpand(size);
        return this.position(this.position() + size);
    }

    public ByteBuffer fill(byte value, int size) {
        int intValue;
        this.autoExpand(size);
        int q = size >>> 3;
        int r = size & 7;
        if (q > 0) {
            intValue = value | value << 8 | value << 16 | value << 24;
            long longValue = intValue;
            longValue <<= 32;
            longValue |= (long)intValue;
            for (int i = q; i > 0; --i) {
                this.putLong(longValue);
            }
        }
        q = r >>> 2;
        r &= 3;
        if (q > 0) {
            intValue = value | value << 8 | value << 16 | value << 24;
            this.putInt(intValue);
        }
        q = r >> 1;
        r &= 1;
        if (q > 0) {
            short shortValue = (short)(value | value << 8);
            this.putShort(shortValue);
        }
        if (r > 0) {
            this.put(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer fillAndReset(byte value, int size) {
        this.autoExpand(size);
        int pos = this.position();
        try {
            this.fill(value, size);
        }
        finally {
            this.position(pos);
        }
        return this;
    }

    public ByteBuffer fill(int size) {
        this.autoExpand(size);
        int q = size >>> 3;
        int r = size & 7;
        for (int i = q; i > 0; --i) {
            this.putLong(0L);
        }
        q = r >>> 2;
        r &= 3;
        if (q > 0) {
            this.putInt(0);
        }
        q = r >> 1;
        r &= 1;
        if (q > 0) {
            this.putShort((short)0);
        }
        if (r > 0) {
            this.put((byte)0);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer fillAndReset(int size) {
        this.autoExpand(size);
        int pos = this.position();
        try {
            this.fill(size);
        }
        finally {
            this.position(pos);
        }
        return this;
    }

    protected ByteBuffer autoExpand(int expectedRemaining) {
        if (this.isAutoExpand()) {
            this.expand(expectedRemaining);
        }
        return this;
    }

    protected ByteBuffer autoExpand(int pos, int expectedRemaining) {
        if (this.isAutoExpand()) {
            this.expand(pos, expectedRemaining);
        }
        return this;
    }

    private static void checkFieldSize(int fieldSize) {
        if (fieldSize < 0) {
            throw new IllegalArgumentException("fieldSize cannot be negative: " + fieldSize);
        }
    }

    private static class DefaultByteBuffer
    extends ByteBuffer {
        private java.nio.ByteBuffer buf;
        private int refCount = 1;
        private boolean autoExpand;
        private boolean pooled;

        protected DefaultByteBuffer() {
        }

        private synchronized void init(java.nio.ByteBuffer buf) {
            this.buf = buf;
            buf.clear();
            buf.order(ByteOrder.BIG_ENDIAN);
            this.autoExpand = false;
            this.pooled = true;
            this.refCount = 1;
        }

        public synchronized void acquire() {
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Object object = this;
            synchronized (object) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
            if (this.pooled) {
                ByteBuffer.release0(this.buf);
            }
            object = containerStack;
            synchronized (object) {
                containerStack.push(this);
            }
        }

        public java.nio.ByteBuffer buf() {
            return this.buf;
        }

        public boolean isDirect() {
            return this.buf.isDirect();
        }

        public boolean isReadOnly() {
            return this.buf.isReadOnly();
        }

        public boolean isAutoExpand() {
            return this.autoExpand;
        }

        public ByteBuffer setAutoExpand(boolean autoExpand) {
            this.autoExpand = autoExpand;
            return this;
        }

        public boolean isPooled() {
            return this.pooled;
        }

        public void setPooled(boolean pooled) {
            this.pooled = pooled;
        }

        public int capacity() {
            return this.buf.capacity();
        }

        public int position() {
            return this.buf.position();
        }

        public ByteBuffer position(int newPosition) {
            this.autoExpand(newPosition, 0);
            this.buf.position(newPosition);
            return this;
        }

        public int limit() {
            return this.buf.limit();
        }

        public ByteBuffer limit(int newLimit) {
            this.autoExpand(newLimit, 0);
            this.buf.limit(newLimit);
            return this;
        }

        public ByteBuffer mark() {
            this.buf.mark();
            return this;
        }

        public ByteBuffer reset() {
            this.buf.reset();
            return this;
        }

        public ByteBuffer clear() {
            this.buf.clear();
            return this;
        }

        public ByteBuffer flip() {
            this.buf.flip();
            return this;
        }

        public ByteBuffer rewind() {
            this.buf.rewind();
            return this;
        }

        public int remaining() {
            return this.buf.remaining();
        }

        public byte get() {
            return this.buf.get();
        }

        public ByteBuffer put(byte b) {
            this.autoExpand(1);
            this.buf.put(b);
            return this;
        }

        public byte get(int index) {
            return this.buf.get(index);
        }

        public ByteBuffer put(int index, byte b) {
            this.autoExpand(index, 1);
            this.buf.put(index, b);
            return this;
        }

        public ByteBuffer get(byte[] dst, int offset, int length) {
            this.buf.get(dst, offset, length);
            return this;
        }

        public ByteBuffer put(java.nio.ByteBuffer src) {
            this.autoExpand(src.remaining());
            this.buf.put(src);
            return this;
        }

        public ByteBuffer put(byte[] src, int offset, int length) {
            this.autoExpand(length);
            this.buf.put(src, offset, length);
            return this;
        }

        public ByteBuffer compact() {
            this.buf.compact();
            return this;
        }

        public int compareTo(ByteBuffer that) {
            return this.buf.compareTo(that.buf());
        }

        public ByteOrder order() {
            return this.buf.order();
        }

        public ByteBuffer order(ByteOrder bo) {
            this.buf.order(bo);
            return this;
        }

        public char getChar() {
            return this.buf.getChar();
        }

        public ByteBuffer putChar(char value) {
            this.autoExpand(2);
            this.buf.putChar(value);
            return this;
        }

        public char getChar(int index) {
            return this.buf.getChar(index);
        }

        public ByteBuffer putChar(int index, char value) {
            this.autoExpand(index, 2);
            this.buf.putChar(index, value);
            return this;
        }

        public CharBuffer asCharBuffer() {
            return this.buf.asCharBuffer();
        }

        public short getShort() {
            return this.buf.getShort();
        }

        public ByteBuffer putShort(short value) {
            this.autoExpand(2);
            this.buf.putShort(value);
            return this;
        }

        public short getShort(int index) {
            return this.buf.getShort(index);
        }

        public ByteBuffer putShort(int index, short value) {
            this.autoExpand(index, 2);
            this.buf.putShort(index, value);
            return this;
        }

        public ShortBuffer asShortBuffer() {
            return this.buf.asShortBuffer();
        }

        public int getInt() {
            return this.buf.getInt();
        }

        public ByteBuffer putInt(int value) {
            this.autoExpand(4);
            this.buf.putInt(value);
            return this;
        }

        public int getInt(int index) {
            return this.buf.getInt(index);
        }

        public ByteBuffer putInt(int index, int value) {
            this.autoExpand(index, 4);
            this.buf.putInt(index, value);
            return this;
        }

        public IntBuffer asIntBuffer() {
            return this.buf.asIntBuffer();
        }

        public long getLong() {
            return this.buf.getLong();
        }

        public ByteBuffer putLong(long value) {
            this.autoExpand(8);
            this.buf.putLong(value);
            return this;
        }

        public long getLong(int index) {
            return this.buf.getLong(index);
        }

        public ByteBuffer putLong(int index, long value) {
            this.autoExpand(index, 8);
            this.buf.putLong(index, value);
            return this;
        }

        public LongBuffer asLongBuffer() {
            return this.buf.asLongBuffer();
        }

        public float getFloat() {
            return this.buf.getFloat();
        }

        public ByteBuffer putFloat(float value) {
            this.autoExpand(4);
            this.buf.putFloat(value);
            return this;
        }

        public float getFloat(int index) {
            return this.buf.getFloat(index);
        }

        public ByteBuffer putFloat(int index, float value) {
            this.autoExpand(index, 4);
            this.buf.putFloat(index, value);
            return this;
        }

        public FloatBuffer asFloatBuffer() {
            return this.buf.asFloatBuffer();
        }

        public double getDouble() {
            return this.buf.getDouble();
        }

        public ByteBuffer putDouble(double value) {
            this.autoExpand(8);
            this.buf.putDouble(value);
            return this;
        }

        public double getDouble(int index) {
            return this.buf.getDouble(index);
        }

        public ByteBuffer putDouble(int index, double value) {
            this.autoExpand(index, 8);
            this.buf.putDouble(index, value);
            return this;
        }

        public DoubleBuffer asDoubleBuffer() {
            return this.buf.asDoubleBuffer();
        }

        public ByteBuffer expand(int expectedRemaining) {
            int limit;
            int pos;
            int end;
            if (this.autoExpand && (end = (pos = this.buf.position()) + expectedRemaining) > (limit = this.buf.limit())) {
                this.ensureCapacity(end);
                this.buf.limit(end);
            }
            return this;
        }

        public ByteBuffer expand(int pos, int expectedRemaining) {
            int limit;
            int end;
            if (this.autoExpand && (end = pos + expectedRemaining) > (limit = this.buf.limit())) {
                this.ensureCapacity(end);
                this.buf.limit(end);
            }
            return this;
        }

        private void ensureCapacity(int requestedCapacity) {
            int newCapacity;
            if (requestedCapacity <= this.buf.capacity()) {
                return;
            }
            for (newCapacity = 1; newCapacity < requestedCapacity; newCapacity <<= 1) {
            }
            java.nio.ByteBuffer oldBuf = this.buf;
            java.nio.ByteBuffer newBuf = ByteBuffer.allocate0(newCapacity, this.isDirect());
            newBuf.clear();
            newBuf.order(oldBuf.order());
            int pos = oldBuf.position();
            int limit = oldBuf.limit();
            oldBuf.clear();
            newBuf.put(oldBuf);
            newBuf.position(0);
            newBuf.limit(limit);
            newBuf.position(pos);
            this.buf = newBuf;
            ByteBuffer.release0(oldBuf);
        }
    }
}

