/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.support.BaseIoSessionManager;

public abstract class BaseIoConnector
extends BaseIoSessionManager
implements IoConnector {
    private int defaultConnectTimeout = 60;

    protected BaseIoConnector() {
    }

    public ConnectFuture connect(SocketAddress address, IoHandler handler) {
        return this.connect(address, handler, IoFilterChainBuilder.NOOP);
    }

    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler) {
        return this.connect(address, localAddress, handler, IoFilterChainBuilder.NOOP);
    }

    public int getConnectTimeout() {
        return this.defaultConnectTimeout;
    }

    public long getConnectTimeoutMillis() {
        return (long)this.defaultConnectTimeout * 1000L;
    }

    public void setConnectTimeout(int defaultConnectTimeout) {
        if (defaultConnectTimeout <= 0) {
            throw new IllegalArgumentException("defaultConnectTimeout: " + defaultConnectTimeout);
        }
        this.defaultConnectTimeout = defaultConnectTimeout;
    }
}

