/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterLifeCycleException;

public class IoFilterLifeCycleManager {
    private static final IoFilterLifeCycleManager INSTANCE = new IoFilterLifeCycleManager();
    private Map counts = new IdentityHashMap();

    public static IoFilterLifeCycleManager getInstance() {
        return INSTANCE;
    }

    private IoFilterLifeCycleManager() {
    }

    public synchronized void callInitIfNecessary(IoFilter filter) {
        ReferenceCount count = (ReferenceCount)this.counts.get(filter);
        if (count == null) {
            count = new ReferenceCount();
            this.counts.put(filter, count);
            try {
                filter.init();
            }
            catch (Throwable t) {
                throw new IoFilterLifeCycleException("init(): " + filter, t);
            }
        }
    }

    public synchronized void callOnPreAdd(IoFilterChain chain, String name, IoFilter filter, IoFilter.NextFilter nextFilter) {
        ReferenceCount count = (ReferenceCount)this.counts.get(filter);
        if (count == null) {
            throw new IllegalStateException();
        }
        count.increase();
        try {
            filter.onPreAdd(chain, name, nextFilter);
        }
        catch (Throwable t) {
            throw new IoFilterLifeCycleException("onPreAdd(): " + name + ':' + filter + " in " + chain.getSession(), t);
        }
    }

    public synchronized void callOnPreRemove(IoFilterChain chain, String name, IoFilter filter, IoFilter.NextFilter nextFilter) {
        ReferenceCount count = (ReferenceCount)this.counts.get(filter);
        if (count == null || count.get() == 0) {
            return;
        }
        try {
            filter.onPreRemove(chain, name, nextFilter);
        }
        catch (Throwable t) {
            throw new IoFilterLifeCycleException("onPreRemove(): " + name + ':' + filter + " in " + chain.getSession(), t);
        }
    }

    public synchronized void callOnPostAdd(IoFilterChain chain, String name, IoFilter filter, IoFilter.NextFilter nextFilter) {
        ReferenceCount count = (ReferenceCount)this.counts.get(filter);
        if (count == null) {
            throw new IllegalStateException();
        }
        try {
            filter.onPostAdd(chain, name, nextFilter);
        }
        catch (Throwable t) {
            count.decrease();
            throw new IoFilterLifeCycleException("onPostAdd(): " + name + ':' + filter + " in " + chain.getSession(), t);
        }
    }

    public synchronized void callOnPostRemove(IoFilterChain chain, String name, IoFilter filter, IoFilter.NextFilter nextFilter) {
        ReferenceCount count = (ReferenceCount)this.counts.get(filter);
        if (count == null || count.get() == 0) {
            return;
        }
        try {
            filter.onPostRemove(chain, name, nextFilter);
        }
        catch (Throwable t) {
            throw new IoFilterLifeCycleException("onPostRemove(): " + name + ':' + filter + " in " + chain.getSession(), t);
        }
        finally {
            count.decrease();
        }
    }

    public synchronized void callDestroyIfNecessary(IoFilter filter) {
        ReferenceCount count = (ReferenceCount)this.counts.get(filter);
        if (count == null) {
            return;
        }
        if (count.get() == 0) {
            this.counts.remove(filter);
            try {
                filter.destroy();
            }
            catch (Throwable t2) {
                throw new IoFilterLifeCycleException("Failed to destroy: " + filter, t2);
            }
        }
    }

    private static class ReferenceCount {
        private int count;

        private ReferenceCount() {
        }

        public int get() {
            return this.count;
        }

        public int increase() {
            return this.count++;
        }

        public int decrease() {
            return --this.count;
        }
    }
}

