/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.echoserver;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.transport.socket.nio.SocketSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoProtocolHandler
extends IoHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger((Class)EchoProtocolHandler.class);

    public void sessionCreated(IoSession session) {
        if (session instanceof SocketSession) {
            ((SocketSession)session).setSessionReceiveBufferSize(2048);
        }
        session.setIdleTime(IdleStatus.BOTH_IDLE, 10);
        session.setAttribute(SSLFilter.USE_NOTIFICATION);
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        log.info("*** IDLE #" + session.getIdleCount(IdleStatus.BOTH_IDLE) + " ***");
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        cause.printStackTrace();
        session.close();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (!(message instanceof ByteBuffer)) {
            return;
        }
        ByteBuffer rb = (ByteBuffer)message;
        ByteBuffer wb = ByteBuffer.allocate(rb.remaining());
        wb.put(rb);
        wb.flip();
        session.write(wb);
    }
}

