/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.reverser;

import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;

public class ReverseProtocolHandler
extends IoHandlerAdapter {
    private static IoFilter LOGGING_FILTER = new LoggingFilter();
    private static IoFilter CODEC_FILTER = new ProtocolCodecFilter(new TextLineCodecFactory());

    public void sessionCreated(IoSession session) throws Exception {
        session.getFilterChain().addLast("logger", LOGGING_FILTER);
        session.getFilterChain().addLast("codec", CODEC_FILTER);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        cause.printStackTrace();
        session.close();
    }

    public void messageReceived(IoSession session, Object message) {
        String str = message.toString();
        StringBuffer buf = new StringBuffer(str.length());
        for (int i = str.length() - 1; i >= 0; --i) {
            buf.append(str.charAt(i));
        }
        session.write(buf.toString());
    }
}

