/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoSession;
import org.apache.mina.examples.sumup.ClientSessionHandler;
import org.apache.mina.filter.ThreadPoolFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;

public class Client {
    private static final String HOSTNAME = "localhost";
    private static final int PORT = 8080;
    private static final int CONNECT_TIMEOUT = 30;
    private static final boolean USE_CUSTOM_CODEC = true;

    public static void main(String[] args) throws Throwable {
        IoSession session;
        if (args.length == 0) {
            System.out.println("Please specify the list of any integers");
            return;
        }
        int[] values = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = Integer.parseInt(args[i]);
        }
        ThreadPoolFilter ioThreadPoolFilter = new ThreadPoolFilter();
        ThreadPoolFilter protocolThreadPoolFilter = new ThreadPoolFilter();
        SocketConnector connector = new SocketConnector();
        connector.getFilterChain().addFirst("ioThreadPool", ioThreadPoolFilter);
        connector.getFilterChain().addLast("protocolThreadPool", protocolThreadPoolFilter);
        connector.setConnectTimeout(30);
        while (true) {
            try {
                ConnectFuture future = connector.connect(new InetSocketAddress(HOSTNAME, 8080), new ClientSessionHandler(true, values));
                future.join();
                session = future.getSession();
            }
            catch (IOException e) {
                System.err.println("Failed to connect.");
                e.printStackTrace();
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
        session.getCloseFuture().join();
    }
}

