/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.examples.sumup.codec.SumUpProtocolCodecFactory;
import org.apache.mina.examples.sumup.message.AddMessage;
import org.apache.mina.examples.sumup.message.ResultMessage;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.util.SessionLog;

public class ClientSessionHandler
extends IoHandlerAdapter {
    private final boolean useCustomCodec;
    private final int[] values;
    private boolean finished;

    public ClientSessionHandler(boolean useCustomCodec, int[] values) {
        this.useCustomCodec = useCustomCodec;
        this.values = values;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void sessionCreated(IoSession session) throws Exception {
        ProtocolCodecFactory codec = this.useCustomCodec ? new SumUpProtocolCodecFactory(false) : new ObjectSerializationCodecFactory();
        session.getFilterChain().addLast("protocolFilter", new ProtocolCodecFilter(codec));
        session.getFilterChain().addLast("logger", new LoggingFilter());
    }

    public void sessionOpened(IoSession session) {
        for (int i = 0; i < this.values.length; ++i) {
            AddMessage m = new AddMessage();
            m.setSequence(i);
            m.setValue(this.values[i]);
            session.write(m);
        }
    }

    public void messageReceived(IoSession session, Object message) {
        ResultMessage rm = (ResultMessage)message;
        if (rm.isOk()) {
            if (rm.getSequence() == this.values.length - 1) {
                SessionLog.info(session, "The sum: " + rm.getValue());
                session.close();
                this.finished = true;
            }
        } else {
            SessionLog.warn(session, "Server error, disconnecting...");
            session.close();
            this.finished = true;
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }
}

