/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.examples.sumup.codec.SumUpProtocolCodecFactory;
import org.apache.mina.examples.sumup.message.AddMessage;
import org.apache.mina.examples.sumup.message.ResultMessage;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.util.SessionLog;

public class ServerSessionHandler
implements IoHandler {
    private final boolean useCustomCodec;

    public ServerSessionHandler(boolean useCustomCodec) {
        this.useCustomCodec = useCustomCodec;
    }

    public void sessionCreated(IoSession session) throws Exception {
        ProtocolCodecFactory codec = this.useCustomCodec ? new SumUpProtocolCodecFactory(true) : new ObjectSerializationCodecFactory();
        session.getFilterChain().addFirst("protocolFilter", new ProtocolCodecFilter(codec));
        session.getFilterChain().addLast("logger", new LoggingFilter());
    }

    public void sessionOpened(IoSession session) {
        session.setIdleTime(IdleStatus.BOTH_IDLE, 60);
        session.setAttachment(new Integer(0));
    }

    public void sessionClosed(IoSession session) {
    }

    public void messageReceived(IoSession session, Object message) {
        int value;
        AddMessage am = (AddMessage)message;
        int sum = (Integer)session.getAttachment();
        long expectedSum = (long)sum + (long)(value = am.getValue());
        if (expectedSum > Integer.MAX_VALUE || expectedSum < Integer.MIN_VALUE) {
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(false);
            session.write(rm);
        } else {
            sum = (int)expectedSum;
            session.setAttachment(new Integer(sum));
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(true);
            rm.setValue(sum);
            session.write(rm);
        }
    }

    public void messageSent(IoSession session, Object message) {
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        SessionLog.info(session, "Disconnecting the idle.");
        session.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }
}

