/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.examples.sumup.message.AbstractMessage;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;

public abstract class AbstractMessageDecoder
implements MessageDecoder {
    private final int type;
    private int sequence;
    private boolean readHeader;

    protected AbstractMessageDecoder(int type) {
        this.type = type;
    }

    public MessageDecoderResult decodable(IoSession session, ByteBuffer in) {
        if (in.remaining() < 6) {
            return MessageDecoderResult.NEED_DATA;
        }
        if (this.type == in.getShort()) {
            return MessageDecoderResult.OK;
        }
        return MessageDecoderResult.NOT_OK;
    }

    public MessageDecoderResult decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        AbstractMessage m;
        if (!this.readHeader) {
            in.getShort();
            this.sequence = in.getInt();
            this.readHeader = true;
        }
        if ((m = this.decodeBody(session, in)) == null) {
            return MessageDecoderResult.NEED_DATA;
        }
        this.readHeader = false;
        m.setSequence(this.sequence);
        out.write(m);
        return MessageDecoderResult.OK;
    }

    protected abstract AbstractMessage decodeBody(IoSession var1, ByteBuffer var2);
}

