/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.SessionLog;

public class BlacklistFilter
extends IoFilterAdapter {
    private final Set blacklist = new HashSet();

    public void setBlacklist(InetAddress[] addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        this.blacklist.clear();
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress addr = addresses[i];
            if (addr == null) {
                throw new NullPointerException("addresses[" + i + ']');
            }
            this.blacklist.add(addr);
        }
    }

    public void setBlacklist(Collection addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        InetAddress[] inetAddresses = new InetAddress[addresses.size()];
        try {
            this.setBlacklist(addresses.toArray(inetAddresses));
        }
        catch (ArrayStoreException ase) {
            throw new IllegalArgumentException("Collection of addresses must contain only InetAddress instances", ase);
        }
    }

    public synchronized void block(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.blacklist.add(address);
    }

    public synchronized void unblock(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.blacklist.remove(address);
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        if (!this.isBlocked(session)) {
            nextFilter.sessionCreated(session);
        } else {
            this.blockSession(session);
        }
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionOpened(session);
        } else {
            this.blockSession(session);
        }
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionClosed(session);
        } else {
            this.blockSession(session);
        }
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.sessionIdle(session, status);
        } else {
            this.blockSession(session);
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        if (!this.isBlocked(session)) {
            nextFilter.messageReceived(session, message);
        } else {
            this.blockSession(session);
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!this.isBlocked(session)) {
            nextFilter.messageSent(session, message);
        } else {
            this.blockSession(session);
        }
    }

    private void blockSession(IoSession session) {
        SessionLog.info(session, "Remote address in the blacklist; closing.");
        session.close();
    }

    private boolean isBlocked(IoSession session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        return remoteAddress instanceof InetSocketAddress && this.blacklist.contains(((InetSocketAddress)remoteAddress).getAddress());
    }
}

