/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.BlockingQueue;
import org.apache.mina.util.ByteBufferUtil;
import org.apache.mina.util.IdentityHashSet;
import org.apache.mina.util.Queue;
import org.apache.mina.util.Stack;

public class ThreadPoolFilter
extends IoFilterAdapter {
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_KEEP_ALIVE_TIME = 60000;
    private static final Queue threadIdReuseQueue = new Queue();
    private static int threadId = 0;
    private final String threadNamePrefix;
    private final Map buffers = new IdentityHashMap();
    private final BlockingQueue unfetchedSessionBuffers = new BlockingQueue();
    private final Set allSessionBuffers = new IdentityHashSet();
    private Worker leader;
    private final Stack followers = new Stack();
    private final Set allWorkers = new IdentityHashSet();
    private int maximumPoolSize = Integer.MAX_VALUE;
    private int keepAliveTime = 60000;
    private boolean shuttingDown;
    private int poolSize;
    private final Object poolSizeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int acquireThreadId() {
        Queue queue = threadIdReuseQueue;
        synchronized (queue) {
            Integer id = (Integer)threadIdReuseQueue.pop();
            if (id == null) {
                return ++threadId;
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseThreadId(int id) {
        Queue queue = threadIdReuseQueue;
        synchronized (queue) {
            threadIdReuseQueue.push(new Integer(id));
        }
    }

    public ThreadPoolFilter() {
        this("IoThreadPool");
    }

    public ThreadPoolFilter(String threadNamePrefix) {
        if (threadNamePrefix == null) {
            throw new NullPointerException("threadNamePrefix");
        }
        if ((threadNamePrefix = threadNamePrefix.trim()).length() == 0) {
            throw new IllegalArgumentException("threadNamePrefix is empty.");
        }
        this.threadNamePrefix = threadNamePrefix;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        Object object = this.poolSizeLock;
        synchronized (object) {
            return this.poolSize;
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void init() {
        this.shuttingDown = false;
        this.leader = new Worker();
        this.leader.start();
        this.leader.lead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.shuttingDown = true;
        int expectedPoolSize = 0;
        while (this.getPoolSize() != expectedPoolSize) {
            ArrayList allWorkers;
            Object object = this.poolSizeLock;
            synchronized (object) {
                allWorkers = new ArrayList(this.allWorkers);
            }
            if (allWorkers.remove(Thread.currentThread())) {
                expectedPoolSize = 1;
            }
            Iterator i = allWorkers.iterator();
            while (i.hasNext()) {
                Worker worker = (Worker)i.next();
                while (worker.isAlive()) {
                    worker.interrupt();
                    try {
                        worker.join(100L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        this.allSessionBuffers.clear();
        this.unfetchedSessionBuffers.clear();
        this.buffers.clear();
        this.followers.clear();
        this.leader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increasePoolSize(Worker worker) {
        Object object = this.poolSizeLock;
        synchronized (object) {
            ++this.poolSize;
            this.allWorkers.add(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreasePoolSize(Worker worker) {
        Object object = this.poolSizeLock;
        synchronized (object) {
            --this.poolSize;
            this.allWorkers.remove(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(IoFilter.NextFilter nextFilter, IoSession session, EventType type, Object data) {
        BlockingQueue unfetchedSessionBuffers = this.unfetchedSessionBuffers;
        Set allSessionBuffers = this.allSessionBuffers;
        Event event = new Event(type, nextFilter, data);
        BlockingQueue blockingQueue = unfetchedSessionBuffers;
        synchronized (blockingQueue) {
            SessionBuffer buf = this.getSessionBuffer(session);
            Queue eventQueue = buf.eventQueue;
            SessionBuffer sessionBuffer = buf;
            synchronized (sessionBuffer) {
                eventQueue.push(event);
            }
            if (!allSessionBuffers.contains(buf)) {
                allSessionBuffers.add(buf);
                unfetchedSessionBuffers.push(buf);
            }
        }
    }

    protected SessionBuffer fetchSessionBuffer(Queue unfetchedSessionBuffers) {
        return (SessionBuffer)unfetchedSessionBuffers.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionBuffer getSessionBuffer(IoSession session) {
        Map buffers = this.buffers;
        SessionBuffer buf = (SessionBuffer)buffers.get(session);
        if (buf == null) {
            Map map = buffers;
            synchronized (map) {
                buf = (SessionBuffer)buffers.get(session);
                if (buf == null) {
                    buf = new SessionBuffer(session);
                    buffers.put(session, buf);
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionBuffer(SessionBuffer buf) {
        Map buffers = this.buffers;
        IoSession session = buf.session;
        Map map = buffers;
        synchronized (map) {
            buffers.remove(session);
        }
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) {
        nextFilter.sessionCreated(session);
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) {
        this.fireEvent(nextFilter, session, EventType.OPENED, null);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) {
        this.fireEvent(nextFilter, session, EventType.CLOSED, null);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) {
        this.fireEvent(nextFilter, session, EventType.IDLE, status);
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) {
        this.fireEvent(nextFilter, session, EventType.EXCEPTION, cause);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        ByteBufferUtil.acquireIfPossible(message);
        this.fireEvent(nextFilter, session, EventType.RECEIVED, message);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        ByteBufferUtil.acquireIfPossible(message);
        this.fireEvent(nextFilter, session, EventType.SENT, message);
    }

    protected void processEvent(IoFilter.NextFilter nextFilter, IoSession session, EventType type, Object data) {
        if (type == EventType.RECEIVED) {
            nextFilter.messageReceived(session, data);
            ByteBufferUtil.releaseIfPossible(data);
        } else if (type == EventType.SENT) {
            nextFilter.messageSent(session, data);
            ByteBufferUtil.releaseIfPossible(data);
        } else if (type == EventType.EXCEPTION) {
            nextFilter.exceptionCaught(session, (Throwable)data);
        } else if (type == EventType.IDLE) {
            nextFilter.sessionIdle(session, (IdleStatus)data);
        } else if (type == EventType.OPENED) {
            nextFilter.sessionOpened(session);
        } else if (type == EventType.CLOSED) {
            nextFilter.sessionClosed(session);
        }
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) {
        nextFilter.filterWrite(session, writeRequest);
    }

    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session, CloseFuture closeFuture) throws Exception {
        nextFilter.filterClose(session, closeFuture);
    }

    protected static class Event {
        private final EventType type;
        private final IoFilter.NextFilter nextFilter;
        private final Object data;

        public Event(EventType type, IoFilter.NextFilter nextFilter, Object data) {
            this.type = type;
            this.nextFilter = nextFilter;
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public IoFilter.NextFilter getNextFilter() {
            return this.nextFilter;
        }

        public EventType getType() {
            return this.type;
        }
    }

    protected static class EventType {
        public static final EventType OPENED = new EventType("OPENED");
        public static final EventType CLOSED = new EventType("CLOSED");
        public static final EventType READ = new EventType("READ");
        public static final EventType WRITTEN = new EventType("WRITTEN");
        public static final EventType RECEIVED = new EventType("RECEIVED");
        public static final EventType SENT = new EventType("SENT");
        public static final EventType IDLE = new EventType("IDLE");
        public static final EventType EXCEPTION = new EventType("EXCEPTION");
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    private class Worker
    extends Thread {
        private final int id;
        private final Object promotionLock = new Object();
        private boolean dead;

        private Worker() {
            int id;
            this.id = id = ThreadPoolFilter.acquireThreadId();
            this.setName(ThreadPoolFilter.this.threadNamePrefix + '-' + id);
            ThreadPoolFilter.this.increasePoolSize(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lead() {
            Object promotionLock;
            Object object = promotionLock = this.promotionLock;
            synchronized (object) {
                if (this.dead) {
                    return false;
                }
                ThreadPoolFilter.this.leader = this;
                promotionLock.notify();
            }
            return true;
        }

        public void run() {
            while (this.waitForPromotion()) {
                SessionBuffer buf = this.fetchBuffer();
                this.giveUpLead();
                if (buf == null) break;
                this.processEvents(buf);
                this.follow();
                this.releaseBuffer(buf);
            }
            ThreadPoolFilter.this.decreasePoolSize(this);
            ThreadPoolFilter.releaseThreadId(this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SessionBuffer fetchBuffer() {
            BlockingQueue unfetchedSessionBuffers;
            BlockingQueue blockingQueue = unfetchedSessionBuffers = ThreadPoolFilter.this.unfetchedSessionBuffers;
            synchronized (blockingQueue) {
                while (!ThreadPoolFilter.this.shuttingDown) {
                    try {
                        unfetchedSessionBuffers.waitForNewItem();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    return ThreadPoolFilter.this.fetchSessionBuffer(unfetchedSessionBuffers);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvents(SessionBuffer buf) {
            IoSession session = buf.session;
            Queue eventQueue = buf.eventQueue;
            while (true) {
                Event event;
                SessionBuffer sessionBuffer = buf;
                synchronized (sessionBuffer) {
                    event = (Event)eventQueue.pop();
                    if (event == null) {
                        break;
                    }
                }
                ThreadPoolFilter.this.processEvent(event.getNextFilter(), session, event.getType(), event.getData());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void follow() {
            Object promotionLock = this.promotionLock;
            Stack followers = ThreadPoolFilter.this.followers;
            Object object = promotionLock;
            synchronized (object) {
                if (this != ThreadPoolFilter.this.leader) {
                    Stack stack = followers;
                    synchronized (stack) {
                        followers.push(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseBuffer(SessionBuffer buf) {
            BlockingQueue unfetchedSessionBuffers = ThreadPoolFilter.this.unfetchedSessionBuffers;
            Set allSessionBuffers = ThreadPoolFilter.this.allSessionBuffers;
            Queue eventQueue = buf.eventQueue;
            BlockingQueue blockingQueue = unfetchedSessionBuffers;
            synchronized (blockingQueue) {
                if (eventQueue.isEmpty()) {
                    allSessionBuffers.remove(buf);
                    ThreadPoolFilter.this.removeSessionBuffer(buf);
                } else {
                    unfetchedSessionBuffers.push(buf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForPromotion() {
            Object promotionLock = this.promotionLock;
            long startTime = System.currentTimeMillis();
            long currentTime = System.currentTimeMillis();
            Object object = promotionLock;
            synchronized (object) {
                boolean timeToLead;
                int keepAliveTime;
                while (this != ThreadPoolFilter.this.leader && !ThreadPoolFilter.this.shuttingDown && (keepAliveTime = (keepAliveTime = ThreadPoolFilter.this.getKeepAliveTime()) > 0 ? (int)((long)keepAliveTime - (currentTime - startTime)) : Integer.MAX_VALUE) > 0) {
                    try {
                        promotionLock.wait(keepAliveTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    currentTime = System.currentTimeMillis();
                }
                boolean bl = timeToLead = this == ThreadPoolFilter.this.leader && !ThreadPoolFilter.this.shuttingDown;
                if (!timeToLead) {
                    Stack stack = ThreadPoolFilter.this.followers;
                    synchronized (stack) {
                        ThreadPoolFilter.this.followers.remove(this);
                    }
                    this.dead = true;
                }
                return timeToLead;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void giveUpLead() {
            Worker worker;
            Stack followers = ThreadPoolFilter.this.followers;
            do {
                Stack stack = followers;
                synchronized (stack) {
                    worker = (Worker)followers.pop();
                }
                if (worker != null) continue;
                if (ThreadPoolFilter.this.shuttingDown || ThreadPoolFilter.this.getPoolSize() >= ThreadPoolFilter.this.getMaximumPoolSize()) break;
                worker = new Worker();
                worker.lead();
                worker.start();
                break;
            } while (!worker.lead());
        }
    }

    protected static class SessionBuffer {
        private final IoSession session;
        private final Queue eventQueue = new Queue();

        private SessionBuffer(IoSession session) {
            this.session = session;
        }

        public IoSession getSession() {
            return this.session;
        }

        public Queue getEventQueue() {
            return this.eventQueue;
        }
    }
}

