/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public abstract class CumulativeProtocolDecoder
extends ProtocolDecoderAdapter {
    private static final String BUFFER = CumulativeProtocolDecoder.class.getName() + ".Buffer";
    private final int initialCapacity;

    protected CumulativeProtocolDecoder() {
        this(16);
    }

    protected CumulativeProtocolDecoder(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        ByteBuffer buf = (ByteBuffer)session.getAttribute(BUFFER);
        if (buf == null) {
            buf = ByteBuffer.allocate(this.initialCapacity);
            buf.setAutoExpand(true);
            session.setAttribute(BUFFER, buf);
        }
        buf.put(in);
        buf.flip();
        try {
            do {
                int oldPos = buf.position();
                boolean decoded = this.doDecode(session, buf, out);
                if (!decoded) return;
                if (buf.position() != oldPos) continue;
                throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
            } while (buf.hasRemaining());
            return;
        }
        finally {
            buf.compact();
        }
    }

    protected abstract boolean doDecode(IoSession var1, ByteBuffer var2, ProtocolDecoderOutput var3) throws Exception;

    public void dispose(IoSession session) throws Exception {
        ByteBuffer buf = (ByteBuffer)session.getAttribute(BUFFER);
        if (buf != null) {
            buf.release();
            session.removeAttribute(BUFFER);
        }
    }
}

