/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.support;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.util.Queue;

public abstract class SimpleProtocolEncoderOutput
implements ProtocolEncoderOutput {
    private final Queue bufferQueue = new Queue();

    public Queue getBufferQueue() {
        return this.bufferQueue;
    }

    public void write(ByteBuffer buf) {
        this.bufferQueue.push(buf);
    }

    public void mergeAll() {
        ByteBuffer buf;
        int sum = 0;
        int size = this.bufferQueue.size();
        if (size < 2) {
            return;
        }
        for (int i = size - 1; i >= 0; --i) {
            sum += ((ByteBuffer)this.bufferQueue.get(i)).remaining();
        }
        ByteBuffer newBuf = ByteBuffer.allocate(sum);
        while ((buf = (ByteBuffer)this.bufferQueue.pop()) != null) {
            newBuf.put(buf);
            buf.release();
        }
        newBuf.flip();
        this.bufferQueue.push(newBuf);
    }

    public WriteFuture flush() {
        Queue bufferQueue = this.bufferQueue;
        WriteFuture future = null;
        if (bufferQueue.isEmpty()) {
            future = this.doFlush(ByteBuffer.allocate(0).flip());
        } else {
            ByteBuffer buf;
            while ((buf = (ByteBuffer)bufferQueue.pop()) != null) {
                future = this.doFlush(buf);
            }
        }
        if (future == null) {
            throw new IllegalStateException("doFlush must return future.");
        }
        return future;
    }

    protected abstract WriteFuture doFlush(ByteBuffer var1);
}

