/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.textline;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.common.BufferDataException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.textline.LineDelimiter;

public class TextLineDecoder
implements ProtocolDecoder {
    private static final String CONTEXT = TextLineDecoder.class.getName() + ".context";
    private final Charset charset;
    private final LineDelimiter delimiter;
    private ByteBuffer delimBuf;
    private int maxLineLength = 1024;

    public TextLineDecoder() {
        this(Charset.defaultCharset(), LineDelimiter.AUTO);
    }

    public TextLineDecoder(Charset charset) {
        this(charset, LineDelimiter.AUTO);
    }

    public TextLineDecoder(Charset charset, LineDelimiter delimiter) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter");
        }
        this.charset = charset;
        this.delimiter = delimiter;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        if (maxLineLength <= 0) {
            throw new IllegalArgumentException("maxLineLength: " + maxLineLength);
        }
        this.maxLineLength = maxLineLength;
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        Context ctx = (Context)session.getAttribute(CONTEXT);
        if (ctx == null) {
            ctx = new Context();
            session.setAttribute(CONTEXT, ctx);
        }
        if (LineDelimiter.AUTO.equals(this.delimiter)) {
            ctx.setMatchCount(this.decodeAuto(in, ctx.getBuffer(), ctx.getMatchCount(), ctx.getDecoder(), out));
        } else {
            ctx.setMatchCount(this.decodeNormal(in, ctx.getBuffer(), ctx.getMatchCount(), ctx.getDecoder(), out));
        }
    }

    public void dispose(IoSession session) throws Exception {
        Context ctx = (Context)session.getAttribute(CONTEXT);
        if (ctx != null) {
            ctx.getBuffer().release();
            session.removeAttribute(CONTEXT);
        }
    }

    private int decodeAuto(ByteBuffer in, ByteBuffer buf, int matchCount, CharsetDecoder decoder, ProtocolDecoderOutput out) throws CharacterCodingException {
        int oldMatchCount = matchCount;
        int oldPos = in.position();
        int oldLimit = in.limit();
        while (in.hasRemaining()) {
            byte b = in.get();
            boolean matched = false;
            switch (b) {
                case 13: {
                    ++matchCount;
                    break;
                }
                case 10: {
                    ++matchCount;
                    matched = true;
                    break;
                }
                default: {
                    matchCount = 0;
                }
            }
            if (!matched) continue;
            int pos = in.position();
            in.limit(pos - matchCount + oldMatchCount);
            in.position(oldPos);
            buf.put(in);
            if (buf.position() > this.maxLineLength) {
                throw new BufferDataException("Line is too long: " + buf.position());
            }
            buf.flip();
            out.write(buf.getString(decoder));
            buf.clear();
            in.limit(oldLimit);
            in.position(pos);
            oldPos = pos;
            matchCount = 0;
        }
        in.position(oldPos);
        in.limit(in.limit() - matchCount + oldMatchCount);
        buf.put(in);
        return matchCount;
    }

    private int decodeNormal(ByteBuffer in, ByteBuffer buf, int matchCount, CharsetDecoder decoder, ProtocolDecoderOutput out) throws CharacterCodingException {
        if (this.delimBuf == null) {
            ByteBuffer tmp = ByteBuffer.allocate(2).setAutoExpand(true);
            tmp.putString(this.delimiter.getValue(), this.charset.newEncoder());
            tmp.flip();
            this.delimBuf = tmp;
        }
        int oldMatchCount = matchCount;
        int oldPos = in.position();
        int oldLimit = in.limit();
        while (in.hasRemaining()) {
            byte b = in.get();
            if (this.delimBuf.get(matchCount) == b) {
                if (++matchCount != this.delimBuf.limit()) continue;
                int pos = in.position();
                in.limit(pos - matchCount + oldMatchCount);
                in.position(oldPos);
                buf.put(in);
                if (buf.position() > this.maxLineLength) {
                    throw new BufferDataException("Line is too long: " + buf.position());
                }
                buf.flip();
                out.write(buf.getString(decoder));
                buf.clear();
                in.limit(oldLimit);
                in.position(pos);
                oldPos = pos;
                matchCount = 0;
                continue;
            }
            matchCount = 0;
        }
        in.position(oldPos);
        in.limit(in.limit() - matchCount + oldMatchCount);
        buf.put(in);
        return matchCount;
    }

    private class Context {
        private final CharsetDecoder decoder;
        private final ByteBuffer buf;
        private int matchCount = 0;

        private Context() {
            this.decoder = TextLineDecoder.this.charset.newDecoder();
            this.buf = ByteBuffer.allocate(80).setAutoExpand(true);
        }

        public CharsetDecoder getDecoder() {
            return this.decoder;
        }

        public ByteBuffer getBuffer() {
            return this.buf;
        }

        public int getMatchCount() {
            return this.matchCount;
        }

        public void setMatchCount(int matchCount) {
            this.matchCount = matchCount;
        }
    }
}

