/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.spring;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.integration.spring.support.AbstractIoAcceptorFactoryBean;
import org.springframework.util.Assert;

public abstract class InetSocketAddressBindingIoAcceptorFactoryBean
extends AbstractIoAcceptorFactoryBean {
    protected SocketAddress parseSocketAddress(String s) {
        Assert.notNull((Object)s, (String)"null SocketAddress string");
        s = s.trim();
        int colonIndex = s.indexOf(":");
        if (colonIndex > 0) {
            String host = s.substring(0, colonIndex);
            int port = this.parsePort(s.substring(colonIndex + 1));
            return new InetSocketAddress(host, port);
        }
        int port = this.parsePort(s.substring(colonIndex + 1));
        return new InetSocketAddress(port);
    }

    protected int parsePort(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Illegal port number: " + s);
        }
    }
}

