/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.spring;

import java.net.SocketAddress;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.integration.spring.support.AbstractIoAcceptorFactoryBean;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.springframework.util.Assert;

public class VmPipeAcceptorFactoryBean
extends AbstractIoAcceptorFactoryBean {
    protected IoAcceptor createIoAcceptor() throws Exception {
        return new VmPipeAcceptor();
    }

    protected SocketAddress parseSocketAddress(String s) {
        Assert.notNull((Object)s, (String)"null SocketAddress string");
        s = s.trim();
        if (s.startsWith(":")) {
            s = s.substring(1);
        }
        try {
            return new VmPipeAddress(Integer.parseInt(s.trim()));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Illegal vm pipe address: " + s);
        }
    }
}

