/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.spring.support;

import java.net.SocketAddress;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.integration.spring.Binding;
import org.apache.mina.integration.spring.IoFilterMapping;
import org.apache.mina.integration.spring.support.AbstractIoSessionManagerFactoryBean;
import org.springframework.util.Assert;

public abstract class AbstractIoAcceptorFactoryBean
extends AbstractIoSessionManagerFactoryBean {
    protected Binding[] bindings = new Binding[0];

    protected abstract IoAcceptor createIoAcceptor() throws Exception;

    protected Object createInstance() throws Exception {
        IoAcceptor acceptor = this.createIoAcceptor();
        this.initIoSessionManager(acceptor);
        this.initIoAcceptor(acceptor);
        return acceptor;
    }

    protected void initIoAcceptor(IoAcceptor acceptor) throws Exception {
        for (int i = 0; i < this.bindings.length; ++i) {
            Binding b = this.bindings[i];
            DefaultIoFilterChainBuilder chainBuilder = new DefaultIoFilterChainBuilder();
            IoFilterMapping[] fm = b.getFilterMappings();
            for (int j = 0; j < fm.length; ++j) {
                chainBuilder.addLast(fm[j].getName(), fm[j].getFilter());
            }
            SocketAddress address = this.parseSocketAddress(b.getAddress());
            acceptor.bind(address, b.getHandler(), chainBuilder);
        }
    }

    protected void destroyInstance(Object instance) throws Exception {
        IoAcceptor acceptor = (IoAcceptor)instance;
        this.destroyIoAcceptor(acceptor);
        this.destroyIoSessionManager(acceptor);
    }

    protected void destroyIoAcceptor(IoAcceptor acceptor) throws Exception {
        for (int i = 0; i < this.bindings.length; ++i) {
            Binding b = this.bindings[i];
            try {
                acceptor.unbind(this.parseSocketAddress(b.getAddress()));
                continue;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
    }

    public Class getObjectType() {
        return IoAcceptor.class;
    }

    public void setBindings(Binding[] bindings) {
        Assert.notNull((Object)bindings, (String)"Property 'bindings' may not be null");
        this.bindings = bindings;
    }

    protected abstract SocketAddress parseSocketAddress(String var1);
}

