/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.spring.support;

import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSessionManager;
import org.apache.mina.integration.spring.IoFilterMapping;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;

public abstract class AbstractIoSessionManagerFactoryBean
extends AbstractFactoryBean {
    private IoFilterMapping[] filterMappings = new IoFilterMapping[0];

    protected void initIoSessionManager(IoSessionManager sessionManager) throws Exception {
        DefaultIoFilterChainBuilder builder = sessionManager.getFilterChain();
        for (int i = 0; i < this.filterMappings.length; ++i) {
            builder.addLast(this.filterMappings[i].getName(), this.filterMappings[i].getFilter());
        }
    }

    protected void destroyIoSessionManager(IoSessionManager sessionManager) throws Exception {
        sessionManager.getFilterChain().clear();
    }

    public void setFilters(IoFilter[] filters) {
        Assert.notNull((Object)filters, (String)"Property 'filters' may not be null");
        this.filterMappings = new IoFilterMapping[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            this.filterMappings[i] = new IoFilterMapping();
            this.filterMappings[i].setName("managerFilter" + i);
            this.filterMappings[i].setFilter(filters[i]);
        }
    }

    public void setFilterMappings(IoFilterMapping[] filterMappings) {
        Assert.notNull((Object)filterMappings, (String)"Property 'filterMappings' may not be null");
        this.filterMappings = filterMappings;
    }
}

