/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.registry;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.TransportType;
import org.apache.mina.filter.ThreadPoolFilter;
import org.apache.mina.registry.Service;
import org.apache.mina.registry.ServiceRegistry;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;

public class SimpleServiceRegistry
implements ServiceRegistry {
    protected final IoAcceptor socketIoAcceptor = new SocketAcceptor();
    protected final IoAcceptor datagramIoAcceptor = new DatagramAcceptor();
    protected final IoAcceptor vmPipeAcceptor = new VmPipeAcceptor();
    protected final ThreadPoolFilter threadPoolFilter = new ThreadPoolFilter();
    private final Set services = new HashSet();

    public void bind(Service service, IoHandler handler) throws IOException {
        this.bind(service, handler, null);
    }

    public void bind(Service service, IoHandler handler, IoFilterChainBuilder filterChainBuilder) throws IOException {
        IoAcceptor acceptor = this.findAcceptor(service.getTransportType());
        if (filterChainBuilder == null) {
            filterChainBuilder = IoFilterChainBuilder.NOOP;
        }
        acceptor.bind(service.getAddress(), handler, new IoFilterChainBuilderWrapper(service, filterChainBuilder));
        this.services.add(service);
    }

    public synchronized void unbind(Service service) {
        IoAcceptor acceptor = this.findAcceptor(service.getTransportType());
        try {
            acceptor.unbind(service.getAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.services.remove(service);
    }

    public synchronized void unbindAll() {
        Iterator it = new HashSet(this.services).iterator();
        while (it.hasNext()) {
            Service s = (Service)it.next();
            this.unbind(s);
        }
    }

    public IoAcceptor getAcceptor(TransportType transportType) {
        return this.findAcceptor(transportType);
    }

    public synchronized Set getAllServices() {
        return new HashSet(this.services);
    }

    public synchronized Set getServices(String name) {
        HashSet<Service> result = new HashSet<Service>();
        Iterator it = this.services.iterator();
        while (it.hasNext()) {
            Service s = (Service)it.next();
            if (!name.equals(s.getName())) continue;
            result.add(s);
        }
        return result;
    }

    public Set getServices(TransportType transportType) {
        HashSet<Service> result = new HashSet<Service>();
        Iterator it = this.services.iterator();
        while (it.hasNext()) {
            Service s = (Service)it.next();
            if (s.getTransportType() != transportType) continue;
            result.add(s);
        }
        return result;
    }

    public Set getServices(int port) {
        HashSet<Service> result = new HashSet<Service>();
        Iterator it = this.services.iterator();
        while (it.hasNext()) {
            Service s = (Service)it.next();
            SocketAddress addr = s.getAddress();
            int servicePort = addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getPort() : (addr instanceof VmPipeAddress ? ((VmPipeAddress)addr).getPort() : -1);
            if (servicePort != port) continue;
            result.add(s);
        }
        return result;
    }

    protected IoAcceptor findAcceptor(TransportType transportType) {
        if (transportType == TransportType.SOCKET) {
            return this.socketIoAcceptor;
        }
        if (transportType == TransportType.DATAGRAM) {
            return this.datagramIoAcceptor;
        }
        return this.vmPipeAcceptor;
    }

    private class IoFilterChainBuilderWrapper
    implements IoFilterChainBuilder {
        private final Service service;
        private final IoFilterChainBuilder originalBuilder;

        private IoFilterChainBuilderWrapper(Service service, IoFilterChainBuilder originalBuilder) {
            this.service = service;
            this.originalBuilder = originalBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void buildFilterChain(IoFilterChain chain) throws Exception {
            chain.getSession().setAttribute(ServiceRegistry.SERVICE, this.service);
            try {
                this.originalBuilder.buildFilterChain(chain);
            }
            finally {
                chain.addFirst("threadPool", SimpleServiceRegistry.this.threadPoolFilter);
            }
        }
    }
}

