/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.transport.socket.nio.support.DatagramFilterChain;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.apache.mina.transport.socket.nio.support.DatagramSessionManager;
import org.apache.mina.util.ExceptionUtil;
import org.apache.mina.util.Queue;

public class DatagramAcceptorDelegate
extends BaseIoAcceptor
implements IoAcceptor,
DatagramSessionManager {
    private static volatile int nextId = 0;
    private final IoAcceptor wrapper;
    private final int id = nextId++;
    private Selector selector;
    private final Map channels = new HashMap();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final Queue flushingSessions = new Queue();
    private Worker worker;

    public DatagramAcceptorDelegate(IoAcceptor wrapper) {
        this.wrapper = wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address, IoHandler handler, IoFilterChainBuilder filterChainBuilder) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (((InetSocketAddress)address).getPort() == 0) {
            throw new IllegalArgumentException("Unsupported port number: 0");
        }
        if (filterChainBuilder == null) {
            filterChainBuilder = IoFilterChainBuilder.NOOP;
        }
        RegistrationRequest request = new RegistrationRequest(address, handler, filterChainBuilder);
        Object object = this;
        synchronized (object) {
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(request);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            ExceptionUtil.throwException(request.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest request = new CancellationRequest(address);
        Object object = this;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
            Queue e = this.cancelQueue;
            synchronized (e) {
                this.cancelQueue.push(request);
            }
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            request.exception.fillInStackTrace();
            throw request.exception;
        }
    }

    public IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        Selector selector = this.selector;
        DatagramChannel ch = (DatagramChannel)this.channels.get(localAddress);
        if (selector == null || ch == null) {
            throw new IllegalArgumentException("Unknown localAddress: " + localAddress);
        }
        SelectionKey key = ch.keyFor(selector);
        if (key == null) {
            throw new IllegalArgumentException("Unknown localAddress: " + localAddress);
        }
        RegistrationRequest req = (RegistrationRequest)key.attachment();
        DatagramSessionImpl s = new DatagramSessionImpl(this.wrapper, this, ch, req.handler);
        s.setRemoteAddress(remoteAddress);
        s.setSelectionKey(key);
        try {
            this.filterChainBuilder.buildFilterChain(s.getFilterChain());
            req.filterChainBuilder.buildFilterChain(s.getFilterChain());
            ((DatagramFilterChain)s.getFilterChain()).sessionCreated(s);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
        }
        return s;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.worker.start();
        }
    }

    public void flushSession(DatagramSessionImpl session) {
        this.scheduleFlush(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    public void closeSession(DatagramSessionImpl session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(DatagramSessionImpl session) {
        Queue queue = this.flushingSessions;
        synchronized (queue) {
            this.flushingSessions.push(session);
        }
    }

    private void processReadySessions(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            it.remove();
            DatagramChannel ch = (DatagramChannel)key.channel();
            RegistrationRequest req = (RegistrationRequest)key.attachment();
            DatagramSessionImpl session = new DatagramSessionImpl(this.wrapper, this, ch, req.handler);
            session.setSelectionKey(key);
            try {
                ((DatagramFilterChain)session.getFilterChain()).sessionCreated(session);
                if (key.isReadable()) {
                    this.readSession(session);
                }
                if (!key.isWritable()) continue;
                this.scheduleFlush(session);
            }
            catch (Throwable t) {
                ExceptionMonitor.getInstance().exceptionCaught(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramSessionImpl session) {
        ByteBuffer readBuf = ByteBuffer.allocate(2048);
        try {
            SocketAddress remoteAddress = session.getChannel().receive(readBuf.buf());
            if (remoteAddress != null) {
                readBuf.flip();
                session.setRemoteAddress(remoteAddress);
                ByteBuffer newBuf = ByteBuffer.allocate(readBuf.limit());
                newBuf.put(readBuf);
                newBuf.flip();
                session.increaseReadBytes(newBuf.remaining());
                ((DatagramFilterChain)session.getFilterChain()).messageReceived(session, newBuf);
            }
        }
        catch (IOException e) {
            ((DatagramFilterChain)session.getFilterChain()).exceptionCaught(session, e);
        }
        finally {
            readBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            DatagramSessionImpl session;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                session = (DatagramSessionImpl)this.flushingSessions.pop();
            }
            if (session == null) break;
            try {
                this.flush(session);
            }
            catch (IOException e) {
                ((DatagramFilterChain)session.getFilterChain()).exceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(DatagramSessionImpl session) throws IOException {
        DatagramChannel ch = session.getChannel();
        Queue writeRequestQueue = session.getWriteRequestQueue();
        while (true) {
            IoFilter.WriteRequest req;
            Queue queue = writeRequestQueue;
            synchronized (queue) {
                req = (IoFilter.WriteRequest)writeRequestQueue.first();
            }
            if (req == null) break;
            ByteBuffer buf = (ByteBuffer)req.getMessage();
            if (buf.remaining() == 0) {
                Queue queue2 = writeRequestQueue;
                synchronized (queue2) {
                    writeRequestQueue.pop();
                }
                req.getFuture().setWritten(true);
                session.increaseWrittenWriteRequests();
                ((DatagramFilterChain)session.getFilterChain()).messageSent(session, buf);
                continue;
            }
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleFlush(session);
                break;
            }
            if (!key.isValid()) continue;
            int pos = buf.position();
            int writtenBytes = ch.send(buf.buf(), session.getRemoteAddress());
            if (writtenBytes == 0) {
                key.interestOps(key.interestOps() | 4);
                continue;
            }
            if (writtenBytes <= 0) continue;
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            Queue queue3 = writeRequestQueue;
            synchronized (queue3) {
                writeRequestQueue.pop();
            }
            session.increaseWrittenBytes(writtenBytes);
            req.getFuture().setWritten(true);
            session.increaseWrittenWriteRequests();
            ((DatagramFilterChain)session.getFilterChain()).messageSent(session, buf.position(pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            DatagramChannel ch = null;
            try {
                ch = DatagramChannel.open();
                ch.configureBlocking(false);
                ch.socket().bind(req.address);
                ch.register(this.selector, 1, req);
                this.channels.put(req.address, ch);
                continue;
            }
            catch (Throwable t) {
                req.exception = t;
                continue;
            }
            finally {
                RegistrationRequest registrationRequest = req;
                synchronized (registrationRequest) {
                    req.done = true;
                    req.notify();
                }
                if (ch == null || req.exception == null) continue;
                try {
                    ch.close();
                }
                catch (Throwable e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            Object key;
            CancellationRequest request;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                request = (CancellationRequest)this.cancelQueue.pop();
            }
            if (request == null) return;
            DatagramChannel ch = (DatagramChannel)this.channels.remove(request.address);
            try {
                if (ch == null) {
                    request.exception = new IllegalArgumentException("Address not bound: " + request.address);
                    continue;
                }
                key = ch.keyFor(this.selector);
                ((SelectionKey)key).cancel();
                this.selector.wakeup();
                ch.close();
                continue;
            }
            catch (Throwable t) {
                ExceptionMonitor.getInstance().exceptionCaught(t);
                continue;
            }
            finally {
                key = request;
                synchronized (key) {
                    request.done = true;
                    request.notify();
                }
                continue;
            }
            break;
        }
    }

    public void updateTrafficMask(DatagramSessionImpl session) {
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RuntimeException exception;

        private CancellationRequest(SocketAddress address) {
            this.address = address;
        }
    }

    private static class RegistrationRequest {
        private final SocketAddress address;
        private final IoHandler handler;
        private final IoFilterChainBuilder filterChainBuilder;
        private Throwable exception;
        private boolean done;

        private RegistrationRequest(SocketAddress address, IoHandler handler, IoFilterChainBuilder filterChainBuilder) {
            this.address = address;
            this.handler = handler;
            this.filterChainBuilder = filterChainBuilder;
        }
    }

    private class Worker
    extends Thread {
        public Worker() {
            super("DatagramAcceptor-" + DatagramAcceptorDelegate.this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = DatagramAcceptorDelegate.this.selector.select();
                        DatagramAcceptorDelegate.this.registerNew();
                        if (nKeys > 0) {
                            DatagramAcceptorDelegate.this.processReadySessions(DatagramAcceptorDelegate.this.selector.selectedKeys());
                        }
                        DatagramAcceptorDelegate.this.flushSessions();
                        DatagramAcceptorDelegate.this.cancelKeys();
                    } while (!DatagramAcceptorDelegate.this.selector.keys().isEmpty());
                    DatagramAcceptorDelegate datagramAcceptorDelegate = DatagramAcceptorDelegate.this;
                    synchronized (datagramAcceptorDelegate) {
                        if (DatagramAcceptorDelegate.this.selector.keys().isEmpty() && DatagramAcceptorDelegate.this.registerQueue.isEmpty() && DatagramAcceptorDelegate.this.cancelQueue.isEmpty()) {
                            DatagramAcceptorDelegate.this.worker = null;
                            try {
                                DatagramAcceptorDelegate.this.selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                DatagramAcceptorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

