/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSessionManager;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.transport.socket.nio.DatagramSession;
import org.apache.mina.transport.socket.nio.support.DatagramFilterChain;
import org.apache.mina.transport.socket.nio.support.DatagramSessionManager;
import org.apache.mina.util.Queue;

class DatagramSessionImpl
extends BaseIoSession
implements DatagramSession {
    private final IoSessionManager wrapperManager;
    private final DatagramSessionManager managerDelegate;
    private final DatagramFilterChain filterChain;
    private final DatagramChannel ch;
    private final Queue writeRequestQueue;
    private final IoHandler handler;
    private final SocketAddress localAddress;
    private SocketAddress remoteAddress;
    private SelectionKey key;

    DatagramSessionImpl(IoSessionManager wrapperManager, DatagramSessionManager managerDelegate, DatagramChannel ch, IoHandler defaultHandler) {
        this.wrapperManager = wrapperManager;
        this.managerDelegate = managerDelegate;
        this.filterChain = new DatagramFilterChain(this);
        this.ch = ch;
        this.writeRequestQueue = new Queue();
        this.handler = defaultHandler;
        this.remoteAddress = ch.socket().getRemoteSocketAddress();
        this.localAddress = ch.socket().getLocalSocketAddress();
    }

    public IoSessionManager getManager() {
        return this.wrapperManager;
    }

    DatagramSessionManager getManagerDelegate() {
        return this.managerDelegate;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    DatagramChannel getChannel() {
        return this.ch;
    }

    SelectionKey getSelectionKey() {
        return this.key;
    }

    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    protected void close0(CloseFuture closeFuture) {
        this.filterChain.filterClose(this, closeFuture);
    }

    Queue getWriteRequestQueue() {
        return this.writeRequestQueue;
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.filterWrite(this, writeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledWriteRequests() {
        Queue queue = this.writeRequestQueue;
        synchronized (queue) {
            return this.writeRequestQueue.size();
        }
    }

    public TransportType getTransportType() {
        return TransportType.DATAGRAM;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public boolean getReuseAddress() throws SocketException {
        return this.ch.socket().getReuseAddress();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.ch.socket().setReuseAddress(on);
    }

    public int getTrafficClass() throws SocketException {
        return this.ch.socket().getTrafficClass();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.ch.socket().setTrafficClass(tc);
    }

    protected void updateTrafficMask() {
        this.managerDelegate.updateTrafficMask(this);
    }
}

