/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.transport.socket.nio.SocketSessionManager;
import org.apache.mina.transport.socket.nio.support.SocketFilterChain;
import org.apache.mina.transport.socket.nio.support.SocketSessionImpl;
import org.apache.mina.util.Queue;

public class SocketAcceptorDelegate
extends BaseIoAcceptor
implements SocketSessionManager {
    private static volatile int nextId = 0;
    private final IoAcceptor wrapper;
    private final int id = nextId++;
    private final String threadName = "SocketAcceptor-" + this.id;
    private boolean reuseAddress = false;
    private int backlog = 50;
    private int receiveBufferSize = -1;
    private Selector selector;
    private final Map channels = new HashMap();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private Worker worker;

    public SocketAcceptorDelegate(IoAcceptor wrapper) {
        this.wrapper = wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address, IoHandler handler, IoFilterChainBuilder filterChainBuilder) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (((InetSocketAddress)address).getPort() == 0) {
            throw new IllegalArgumentException("Unsupported port number: 0");
        }
        if (filterChainBuilder == null) {
            filterChainBuilder = IoFilterChainBuilder.NOOP;
        }
        RegistrationRequest request = new RegistrationRequest(address, handler, filterChainBuilder);
        Object object = this;
        synchronized (object) {
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(request);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            throw request.exception;
        }
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest request = new CancellationRequest(address);
        Object object = this;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Address not bound: " + address);
            }
            Queue e = this.cancelQueue;
            synchronized (e) {
                this.cancelQueue.push(request);
            }
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            request.exception.fillInStackTrace();
            throw request.exception;
        }
    }

    public int getProcessors() {
        throw new UnsupportedOperationException();
    }

    public void setProcessors(int nProcessor) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            ServerSocketChannel ssc = null;
            try {
                ssc = ServerSocketChannel.open();
                ssc.configureBlocking(false);
                ssc.socket().setReuseAddress(this.isReuseAddress());
                if (this.getReceiveBufferSize() > 0) {
                    ssc.socket().setReceiveBufferSize(this.getReceiveBufferSize());
                }
                ssc.socket().bind(req.address, this.getBacklog());
                ssc.register(this.selector, 16, req);
                this.channels.put(req.address, ssc);
                continue;
            }
            catch (IOException e) {
                req.exception = e;
                continue;
            }
            finally {
                RegistrationRequest e = req;
                synchronized (e) {
                    req.done = true;
                    req.notify();
                }
                if (ssc == null || req.exception == null) continue;
                try {
                    ssc.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            CancellationRequest request;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                request = (CancellationRequest)this.cancelQueue.pop();
            }
            if (request == null) return;
            ServerSocketChannel ssc = (ServerSocketChannel)this.channels.remove(request.address);
            try {
                if (ssc == null) {
                    request.exception = new IllegalArgumentException("Address not bound: " + request.address);
                    continue;
                }
                SelectionKey key = ssc.keyFor(this.selector);
                key.cancel();
                this.selector.wakeup();
                ssc.close();
                continue;
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
                continue;
            }
            finally {
                CancellationRequest cancellationRequest = request;
                synchronized (cancellationRequest) {
                    request.done = true;
                    request.notify();
                }
                continue;
            }
            break;
        }
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog <= 0) {
            throw new IllegalArgumentException("backlog: " + backlog);
        }
        this.backlog = backlog;
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RuntimeException exception;

        private CancellationRequest(SocketAddress address) {
            this.address = address;
        }
    }

    private static class RegistrationRequest {
        private final SocketAddress address;
        private final IoHandler handler;
        private final IoFilterChainBuilder filterChainBuilder;
        private IOException exception;
        private boolean done;

        private RegistrationRequest(SocketAddress address, IoHandler handler, IoFilterChainBuilder filterChainBuilder) {
            this.address = address;
            this.handler = handler;
            this.filterChainBuilder = filterChainBuilder;
        }
    }

    private class Worker
    extends Thread {
        public Worker() {
            super(SocketAcceptorDelegate.this.threadName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = SocketAcceptorDelegate.this.selector.select();
                        SocketAcceptorDelegate.this.registerNew();
                        SocketAcceptorDelegate.this.cancelKeys();
                        if (nKeys <= 0) continue;
                        this.processSessions(SocketAcceptorDelegate.this.selector.selectedKeys());
                    } while (!SocketAcceptorDelegate.this.selector.keys().isEmpty());
                    SocketAcceptorDelegate socketAcceptorDelegate = SocketAcceptorDelegate.this;
                    synchronized (socketAcceptorDelegate) {
                        if (SocketAcceptorDelegate.this.selector.keys().isEmpty() && SocketAcceptorDelegate.this.registerQueue.isEmpty() && SocketAcceptorDelegate.this.cancelQueue.isEmpty()) {
                            SocketAcceptorDelegate.this.worker = null;
                            try {
                                SocketAcceptorDelegate.this.selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                SocketAcceptorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processSessions(Set keys) throws IOException {
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                ServerSocketChannel ssc;
                SocketChannel ch;
                SelectionKey key = (SelectionKey)it.next();
                it.remove();
                if (!key.isAcceptable() || (ch = (ssc = (ServerSocketChannel)key.channel()).accept()) == null) continue;
                boolean success = false;
                try {
                    RegistrationRequest req = (RegistrationRequest)key.attachment();
                    SocketSessionImpl session = new SocketSessionImpl(SocketAcceptorDelegate.this.wrapper, ch, req.handler);
                    SocketAcceptorDelegate.this.filterChainBuilder.buildFilterChain(session.getFilterChain());
                    req.filterChainBuilder.buildFilterChain(session.getFilterChain());
                    ((SocketFilterChain)session.getFilterChain()).sessionCreated(session);
                    session.getIoProcessor().addNew(session);
                    success = true;
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                }
                finally {
                    if (success) continue;
                    ch.close();
                }
            }
        }
    }
}

