/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.transport.socket.nio.SocketSessionManager;
import org.apache.mina.transport.socket.nio.support.SocketFilterChain;
import org.apache.mina.transport.socket.nio.support.SocketSessionImpl;
import org.apache.mina.util.ExceptionUtil;
import org.apache.mina.util.Queue;

public class SocketConnectorDelegate
extends BaseIoConnector
implements SocketSessionManager {
    private static volatile int nextId = 0;
    private final IoConnector wrapper;
    private final int id = nextId++;
    private final String threadName = "SocketConnector-" + this.id;
    private Selector selector;
    private final Queue connectQueue = new Queue();
    private Worker worker;

    public SocketConnectorDelegate(IoConnector wrapper) {
        this.wrapper = wrapper;
    }

    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoFilterChainBuilder filterChainBuilder) {
        return this.connect(address, null, handler, filterChainBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoFilterChainBuilder filterChainBuilder) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        if (filterChainBuilder == null) {
            filterChainBuilder = IoFilterChainBuilder.NOOP;
        }
        SocketChannel ch = null;
        boolean success = false;
        try {
            ch = SocketChannel.open();
            ch.socket().setReuseAddress(true);
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.configureBlocking(false);
            if (ch.connect(address)) {
                SocketSessionImpl session = this.newSession(ch, handler, filterChainBuilder);
                success = true;
                ConnectFuture future = new ConnectFuture();
                future.setSession(session);
                ConnectFuture connectFuture = future;
                return connectFuture;
            }
            success = true;
        }
        catch (IOException e) {
            ConnectFuture connectFuture = ConnectFuture.newFailedFuture(e);
            return connectFuture;
        }
        finally {
            if (!success && ch != null) {
                try {
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        ConnectionRequest request = new ConnectionRequest(ch, this.getConnectTimeout(), handler, filterChainBuilder);
        SocketConnectorDelegate socketConnectorDelegate = this;
        synchronized (socketConnectorDelegate) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                try {
                    ch.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
                return ConnectFuture.newFailedFuture(e);
            }
            Queue queue = this.connectQueue;
            synchronized (queue) {
                this.connectQueue.push(request);
            }
            this.selector.wakeup();
        }
        return request;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        if (this.connectQueue.isEmpty()) {
            return;
        }
        while (true) {
            ConnectionRequest req;
            Queue queue = this.connectQueue;
            synchronized (queue) {
                req = (ConnectionRequest)this.connectQueue.pop();
            }
            if (req == null) break;
            SocketChannel ch = req.channel;
            try {
                ch.register(this.selector, 8, req);
            }
            catch (IOException e) {
                req.setException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessions(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            if (!key.isConnectable()) continue;
            SocketChannel ch = (SocketChannel)key.channel();
            ConnectionRequest entry = (ConnectionRequest)key.attachment();
            boolean success = false;
            try {
                ch.finishConnect();
                SocketSessionImpl session = this.newSession(ch, entry.handler, entry.filterChainBuilder);
                entry.setSession(session);
                success = true;
            }
            catch (Throwable e) {
                entry.setException(e);
            }
            finally {
                key.cancel();
                if (success) continue;
                try {
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        keys.clear();
    }

    private void processTimedOutSessions(Set keys) {
        long currentTime = System.currentTimeMillis();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            ConnectionRequest entry;
            SelectionKey key = (SelectionKey)it.next();
            if (!key.isValid() || currentTime < (entry = (ConnectionRequest)key.attachment()).deadline) continue;
            entry.setException(new ConnectException());
            key.cancel();
        }
    }

    private SocketSessionImpl newSession(SocketChannel ch, IoHandler handler, IoFilterChainBuilder filterChainBuilder) throws IOException {
        SocketSessionImpl session = new SocketSessionImpl(this.wrapper, ch, handler);
        try {
            this.filterChainBuilder.buildFilterChain(session.getFilterChain());
            filterChainBuilder.buildFilterChain(session.getFilterChain());
            ((SocketFilterChain)session.getFilterChain()).sessionCreated(session);
        }
        catch (Throwable e) {
            ExceptionUtil.throwException(e);
        }
        session.getIoProcessor().addNew(session);
        return session;
    }

    public int getProcessors() {
        throw new UnsupportedOperationException();
    }

    public void setProcessors(int nProcessor) {
        throw new UnsupportedOperationException();
    }

    private static class ConnectionRequest
    extends ConnectFuture {
        private final SocketChannel channel;
        private final long deadline;
        private final IoHandler handler;
        private final IoFilterChainBuilder filterChainBuilder;

        private ConnectionRequest(SocketChannel channel, int timeout, IoHandler handler, IoFilterChainBuilder filterChainBuilder) {
            this.channel = channel;
            this.deadline = System.currentTimeMillis() + (long)timeout * 1000L;
            this.handler = handler;
            this.filterChainBuilder = filterChainBuilder;
        }
    }

    private class Worker
    extends Thread {
        public Worker() {
            super(SocketConnectorDelegate.this.threadName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = SocketConnectorDelegate.this.selector.select(1000L);
                        SocketConnectorDelegate.this.registerNew();
                        if (nKeys > 0) {
                            SocketConnectorDelegate.this.processSessions(SocketConnectorDelegate.this.selector.selectedKeys());
                        }
                        SocketConnectorDelegate.this.processTimedOutSessions(SocketConnectorDelegate.this.selector.keys());
                    } while (!SocketConnectorDelegate.this.selector.keys().isEmpty());
                    SocketConnectorDelegate socketConnectorDelegate = SocketConnectorDelegate.this;
                    synchronized (socketConnectorDelegate) {
                        if (SocketConnectorDelegate.this.selector.keys().isEmpty() && SocketConnectorDelegate.this.connectQueue.isEmpty()) {
                            SocketConnectorDelegate.this.worker = null;
                            try {
                                SocketConnectorDelegate.this.selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                SocketConnectorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

