/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.WriteTimeoutException;
import org.apache.mina.transport.socket.nio.support.SocketFilterChain;
import org.apache.mina.transport.socket.nio.support.SocketSessionImpl;
import org.apache.mina.util.Queue;

class SocketIoProcessor {
    private static final String PROCESSORS_PROPERTY = "mina.socket.processors";
    private static final String THREAD_PREFIX = "SocketIoProcessor-";
    private static final int DEFAULT_PROCESSORS = 1;
    private static final int PROCESSOR_COUNT = SocketIoProcessor.configureProcessorCount();
    private static final SocketIoProcessor[] PROCESSORS = SocketIoProcessor.createProcessors();
    private static int nextId;
    private final String threadName;
    private Selector selector;
    private final Queue newSessions = new Queue();
    private final Queue removingSessions = new Queue();
    private final Queue flushingSessions = new Queue();
    private final Queue trafficControllingSessions = new Queue();
    private Worker worker;
    private long lastIdleCheckTime = System.currentTimeMillis();

    static synchronized SocketIoProcessor getInstance() {
        SocketIoProcessor processor = PROCESSORS[nextId++];
        nextId %= PROCESSOR_COUNT;
        return processor;
    }

    private SocketIoProcessor(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNew(SocketSessionImpl session) throws IOException {
        SocketIoProcessor socketIoProcessor = this;
        synchronized (socketIoProcessor) {
            Queue queue = this.newSessions;
            synchronized (queue) {
                this.newSessions.push(session);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
    }

    void remove(SocketSessionImpl session) throws IOException {
        this.scheduleRemove(session);
        this.startupWorker();
        this.selector.wakeup();
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.worker.start();
        }
    }

    void flush(SocketSessionImpl session) {
        this.scheduleFlush(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    void updateTrafficMask(SocketSessionImpl session) {
        this.scheduleTrafficControl(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRemove(SocketSessionImpl session) {
        Queue queue = this.removingSessions;
        synchronized (queue) {
            this.removingSessions.push(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(SocketSessionImpl session) {
        Queue queue = this.flushingSessions;
        synchronized (queue) {
            this.flushingSessions.push(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTrafficControl(SocketSessionImpl session) {
        Queue queue = this.trafficControllingSessions;
        synchronized (queue) {
            this.trafficControllingSessions.push(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddNew() {
        if (this.newSessions.isEmpty()) {
            return;
        }
        while (true) {
            boolean registered;
            SocketSessionImpl session;
            Queue queue = this.newSessions;
            synchronized (queue) {
                session = (SocketSessionImpl)this.newSessions.pop();
            }
            if (session == null) break;
            SocketChannel ch = session.getChannel();
            try {
                ch.configureBlocking(false);
                session.setSelectionKey(ch.register(this.selector, 1, session));
                registered = true;
            }
            catch (IOException e) {
                registered = false;
                ((SocketFilterChain)session.getFilterChain()).exceptionCaught(session, e);
            }
            if (!registered) continue;
            ((SocketFilterChain)session.getFilterChain()).sessionOpened(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doRemove() {
        if (this.removingSessions.isEmpty()) {
            return;
        }
        while (true) {
            Queue queue = this.removingSessions;
            // MONITORENTER : queue
            SocketSessionImpl session = (SocketSessionImpl)this.removingSessions.pop();
            // MONITOREXIT : queue
            if (session == null) {
                return;
            }
            SocketChannel ch = session.getChannel();
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleRemove(session);
                return;
            }
            if (!key.isValid()) continue;
            try {
                key.cancel();
                ch.close();
                continue;
            }
            catch (IOException e) {
                ((SocketFilterChain)session.getFilterChain()).exceptionCaught(session, e);
                continue;
            }
            finally {
                this.releaseWriteBuffers(session);
                ((SocketFilterChain)session.getFilterChain()).sessionClosed(session);
                session.getCloseFuture().setClosed();
                continue;
            }
            break;
        }
    }

    private void process(Set selectedKeys) {
        Iterator it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            SocketSessionImpl session = (SocketSessionImpl)key.attachment();
            if (key.isReadable() && session.getTrafficMask().isReadable()) {
                this.read(session);
            }
            if (!key.isWritable() || !session.getTrafficMask().isWritable()) continue;
            this.scheduleFlush(session);
        }
        selectedKeys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(SocketSessionImpl session) {
        ByteBuffer buf = ByteBuffer.allocate(session.getSessionReceiveBufferSize());
        SocketChannel ch = session.getChannel();
        try {
            int ret;
            int readBytes = 0;
            buf.clear();
            try {
                while ((ret = ch.read(buf.buf())) > 0) {
                    readBytes += ret;
                }
            }
            finally {
                buf.flip();
            }
            session.increaseReadBytes(readBytes);
            if (readBytes > 0) {
                ByteBuffer newBuf = ByteBuffer.allocate(readBytes);
                newBuf.put(buf);
                newBuf.flip();
                ((SocketFilterChain)session.getFilterChain()).messageReceived(session, newBuf);
            }
            if (ret < 0) {
                this.scheduleRemove(session);
            }
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                this.scheduleRemove(session);
            }
            ((SocketFilterChain)session.getFilterChain()).exceptionCaught(session, e);
        }
        finally {
            buf.release();
        }
    }

    private void notifyIdleness() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastIdleCheckTime >= 1000L) {
            this.lastIdleCheckTime = currentTime;
            Set<SelectionKey> keys = this.selector.keys();
            if (keys != null) {
                Iterator<SelectionKey> it = keys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    SocketSessionImpl session = (SocketSessionImpl)key.attachment();
                    this.notifyIdleness(session, currentTime);
                }
            }
        }
    }

    private void notifyIdleness(SocketSessionImpl session, long currentTime) {
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(session.getLastIoTime(), session.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(session.getLastReadTime(), session.getLastIdleTime(IdleStatus.READER_IDLE)));
        this.notifyIdleness0(session, currentTime, session.getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(session.getLastWriteTime(), session.getLastIdleTime(IdleStatus.WRITER_IDLE)));
        this.notifyWriteTimeout(session, currentTime, session.getWriteTimeoutInMillis(), session.getLastWriteTime());
    }

    private void notifyIdleness0(SocketSessionImpl session, long currentTime, long idleTime, IdleStatus status, long lastIoTime) {
        if (idleTime > 0L && lastIoTime != 0L && currentTime - lastIoTime >= idleTime) {
            session.increaseIdleCount(status);
            ((SocketFilterChain)session.getFilterChain()).sessionIdle(session, status);
        }
    }

    private void notifyWriteTimeout(SocketSessionImpl session, long currentTime, long writeTimeout, long lastIoTime) {
        SelectionKey key = session.getSelectionKey();
        if (writeTimeout > 0L && currentTime - lastIoTime >= writeTimeout && key != null && key.isValid() && (key.interestOps() & 4) != 0) {
            ((SocketFilterChain)session.getFilterChain()).exceptionCaught(session, new WriteTimeoutException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            SocketSessionImpl session;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                session = (SocketSessionImpl)this.flushingSessions.pop();
            }
            if (session == null) break;
            if (!session.isConnected()) {
                this.releaseWriteBuffers(session);
                continue;
            }
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleFlush(session);
                break;
            }
            if (!key.isValid()) continue;
            try {
                this.doFlush(session);
            }
            catch (IOException e) {
                this.scheduleRemove(session);
                ((SocketFilterChain)session.getFilterChain()).exceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWriteBuffers(SocketSessionImpl session) {
        IoFilter.WriteRequest req;
        Queue writeRequestQueue = session.getWriteRequestQueue();
        while ((req = (IoFilter.WriteRequest)writeRequestQueue.pop()) != null) {
            try {
                ((ByteBuffer)req.getMessage()).release();
            }
            catch (IllegalStateException e) {
                ((SocketFilterChain)session.getFilterChain()).exceptionCaught(session, e);
            }
            finally {
                req.getFuture().setWritten(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(SocketSessionImpl session) throws IOException {
        block9: {
            SelectionKey key = session.getSelectionKey();
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            SocketChannel ch = session.getChannel();
            Queue writeRequestQueue = session.getWriteRequestQueue();
            while (true) {
                IoFilter.WriteRequest req;
                Queue queue = writeRequestQueue;
                synchronized (queue) {
                    req = (IoFilter.WriteRequest)writeRequestQueue.first();
                }
                if (req == null) break block9;
                ByteBuffer buf = (ByteBuffer)req.getMessage();
                if (buf.remaining() == 0) {
                    Queue queue2 = writeRequestQueue;
                    synchronized (queue2) {
                        writeRequestQueue.pop();
                    }
                    req.getFuture().setWritten(true);
                    session.increaseWrittenWriteRequests();
                    ((SocketFilterChain)session.getFilterChain()).messageSent(session, buf.reset());
                    continue;
                }
                int writtenBytes = ch.write(buf.buf());
                if (writtenBytes > 0) {
                    session.increaseWrittenBytes(writtenBytes);
                }
                if (buf.hasRemaining()) break;
            }
            key.interestOps(key.interestOps() | 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateTrafficMask() {
        if (this.trafficControllingSessions.isEmpty()) {
            return;
        }
        while (true) {
            Queue writeRequestQueue;
            SocketSessionImpl session;
            Queue queue = this.trafficControllingSessions;
            synchronized (queue) {
                session = (SocketSessionImpl)this.trafficControllingSessions.pop();
            }
            if (session == null) break;
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleTrafficControl(session);
                break;
            }
            if (!key.isValid()) continue;
            int ops = 1;
            Queue queue2 = writeRequestQueue = session.getWriteRequestQueue();
            synchronized (queue2) {
                if (!writeRequestQueue.isEmpty()) {
                    ops |= 4;
                }
            }
            int mask = session.getTrafficMask().getInterestOps();
            key.interestOps(ops & mask);
        }
    }

    private static int configureProcessorCount() {
        int processors = 1;
        String processorProperty = System.getProperty(PROCESSORS_PROPERTY);
        if (processorProperty != null) {
            try {
                processors = Integer.parseInt(processorProperty);
            }
            catch (NumberFormatException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
            processors = Math.max(processors, 1);
            System.setProperty(PROCESSORS_PROPERTY, String.valueOf(processors));
        }
        return processors;
    }

    private static SocketIoProcessor[] createProcessors() {
        SocketIoProcessor[] processors = new SocketIoProcessor[PROCESSOR_COUNT];
        for (int i = 0; i < PROCESSOR_COUNT; ++i) {
            processors[i] = new SocketIoProcessor(THREAD_PREFIX + i);
        }
        return processors;
    }

    private class Worker
    extends Thread {
        public Worker() {
            super(SocketIoProcessor.this.threadName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = SocketIoProcessor.this.selector.select(1000L);
                        SocketIoProcessor.this.doAddNew();
                        SocketIoProcessor.this.doUpdateTrafficMask();
                        if (nKeys > 0) {
                            SocketIoProcessor.this.process(SocketIoProcessor.this.selector.selectedKeys());
                        }
                        SocketIoProcessor.this.doFlush();
                        SocketIoProcessor.this.doRemove();
                        SocketIoProcessor.this.notifyIdleness();
                    } while (!SocketIoProcessor.this.selector.keys().isEmpty());
                    SocketIoProcessor socketIoProcessor = SocketIoProcessor.this;
                    synchronized (socketIoProcessor) {
                        if (SocketIoProcessor.this.selector.keys().isEmpty() && SocketIoProcessor.this.newSessions.isEmpty()) {
                            SocketIoProcessor.this.worker = null;
                            try {
                                SocketIoProcessor.this.selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                SocketIoProcessor.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

