/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSessionManager;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.transport.socket.nio.SocketSession;
import org.apache.mina.transport.socket.nio.support.SocketFilterChain;
import org.apache.mina.transport.socket.nio.support.SocketIoProcessor;
import org.apache.mina.util.Queue;

class SocketSessionImpl
extends BaseIoSession
implements SocketSession {
    private static final int DEFAULT_READ_BUFFER_SIZE = 1024;
    private final IoSessionManager manager;
    private final SocketIoProcessor ioProcessor;
    private final SocketFilterChain filterChain;
    private final SocketChannel ch;
    private final Queue writeRequestQueue;
    private final IoHandler handler;
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;
    private SelectionKey key;
    private int readBufferSize = 1024;

    public SocketSessionImpl(IoSessionManager manager, SocketChannel ch, IoHandler defaultHandler) {
        this.manager = manager;
        this.ioProcessor = SocketIoProcessor.getInstance();
        this.filterChain = new SocketFilterChain(this);
        this.ch = ch;
        this.writeRequestQueue = new Queue();
        this.handler = defaultHandler;
        this.remoteAddress = ch.socket().getRemoteSocketAddress();
        this.localAddress = ch.socket().getLocalSocketAddress();
    }

    public IoSessionManager getManager() {
        return this.manager;
    }

    SocketIoProcessor getIoProcessor() {
        return this.ioProcessor;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    SocketChannel getChannel() {
        return this.ch;
    }

    SelectionKey getSelectionKey() {
        return this.key;
    }

    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    protected void close0(CloseFuture closeFuture) {
        this.filterChain.filterClose(this, closeFuture);
    }

    Queue getWriteRequestQueue() {
        return this.writeRequestQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledWriteRequests() {
        Queue queue = this.writeRequestQueue;
        synchronized (queue) {
            return this.writeRequestQueue.size();
        }
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.filterWrite(this, writeRequest);
    }

    public TransportType getTransportType() {
        return TransportType.SOCKET;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public boolean getKeepAlive() throws SocketException {
        return this.ch.socket().getKeepAlive();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.ch.socket().setKeepAlive(on);
    }

    public boolean getOOBInline() throws SocketException {
        return this.ch.socket().getOOBInline();
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.ch.socket().setOOBInline(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.ch.socket().getReuseAddress();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.ch.socket().setReuseAddress(on);
    }

    public int getSoLinger() throws SocketException {
        return this.ch.socket().getSoLinger();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.ch.socket().setSoLinger(on, linger);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.ch.socket().getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.ch.socket().setTcpNoDelay(on);
    }

    public int getTrafficClass() throws SocketException {
        return this.ch.socket().getTrafficClass();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.ch.socket().setTrafficClass(tc);
    }

    public int getSendBufferSize() throws SocketException {
        return this.ch.socket().getSendBufferSize();
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.ch.socket().setSendBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.ch.socket().getReceiveBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.ch.socket().setReceiveBufferSize(size);
    }

    public int getSessionReceiveBufferSize() {
        return this.readBufferSize;
    }

    public void setSessionReceiveBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid session receive buffer size: " + size);
        }
        this.readBufferSize = size;
    }

    protected void updateTrafficMask() {
        this.ioProcessor.updateTrafficMask(this);
    }
}

