/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.support.VmPipe;

public class VmPipeAcceptor
extends BaseIoAcceptor {
    static final Map boundHandlers = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address, IoHandler handler, IoFilterChainBuilder filterChainBuilder) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (filterChainBuilder == null) {
            filterChainBuilder = IoFilterChainBuilder.NOOP;
        }
        Map map = boundHandlers;
        synchronized (map) {
            if (boundHandlers.containsKey(address)) {
                throw new IOException("Address already bound: " + address);
            }
            boundHandlers.put(address, new VmPipe(this, (VmPipeAddress)address, handler, filterChainBuilder));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        Map map = boundHandlers;
        synchronized (map) {
            boundHandlers.remove(address);
        }
    }
}

