/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;
import org.apache.mina.util.AnonymousSocketAddress;

public class VmPipeConnector
extends BaseIoConnector {
    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoFilterChainBuilder filterChainBuilder) {
        return this.connect(address, null, handler, filterChainBuilder);
    }

    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoFilterChainBuilder filterChainBuilder) {
        VmPipe entry;
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (filterChainBuilder == null) {
            filterChainBuilder = IoFilterChainBuilder.NOOP;
        }
        if ((entry = (VmPipe)VmPipeAcceptor.boundHandlers.get(address)) == null) {
            return ConnectFuture.newFailedFuture(new IOException("Endpoint unavailable: " + address));
        }
        ConnectFuture future = new ConnectFuture();
        try {
            VmPipeSessionImpl session = new VmPipeSessionImpl(this, new Object(), AnonymousSocketAddress.INSTANCE, handler, filterChainBuilder, entry);
            future.setSession(session);
        }
        catch (IOException e) {
            future.setException(e);
        }
        return future;
    }
}

