/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe.support;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;
import org.apache.mina.util.Queue;

public class VmPipeFilterChain
extends AbstractIoFilterChain {
    public VmPipeFilterChain(IoSession session) {
        super(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession session, Object message) {
        VmPipeSessionImpl s = (VmPipeSessionImpl)session;
        Object object = s.lock;
        synchronized (object) {
            if (!s.getTrafficMask().isReadable()) {
                Queue queue = s.pendingDataQueue;
                synchronized (queue) {
                    s.pendingDataQueue.push(message);
                }
            } else {
                int byteCount = 1;
                if (message instanceof ByteBuffer) {
                    byteCount = ((ByteBuffer)message).remaining();
                }
                s.increaseReadBytes(byteCount);
                super.messageReceived(s, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        VmPipeSessionImpl s = (VmPipeSessionImpl)session;
        Object object = s.lock;
        synchronized (object) {
            if (s.isConnected()) {
                if (!s.getTrafficMask().isWritable()) {
                    Queue queue = s.pendingDataQueue;
                    synchronized (queue) {
                        s.pendingDataQueue.push(writeRequest);
                    }
                } else {
                    Object message = writeRequest.getMessage();
                    int byteCount = 1;
                    Object messageCopy = message;
                    if (message instanceof ByteBuffer) {
                        ByteBuffer rb = (ByteBuffer)message;
                        byteCount = rb.remaining();
                        ByteBuffer wb = ByteBuffer.allocate(rb.remaining());
                        wb.put(rb);
                        wb.flip();
                        messageCopy = wb;
                    }
                    s.increaseWrittenBytes(byteCount);
                    s.increaseWrittenWriteRequests();
                    ((VmPipeFilterChain)s.getFilterChain()).messageSent(s, message);
                    ((VmPipeFilterChain)s.remoteSession.getFilterChain()).messageReceived(s.remoteSession, messageCopy);
                    writeRequest.getFuture().setWritten(true);
                }
            } else {
                writeRequest.getFuture().setWritten(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose(IoSession session, CloseFuture closeFuture) {
        VmPipeSessionImpl s = (VmPipeSessionImpl)session;
        Object object = s.lock;
        synchronized (object) {
            if (!closeFuture.isClosed()) {
                ((VmPipeFilterChain)s.getFilterChain()).sessionClosed(session);
                closeFuture.setClosed();
                s.remoteSession.close();
            }
        }
    }
}

