/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe.support;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSessionManager;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.transport.vmpipe.VmPipeSession;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.transport.vmpipe.support.VmPipeFilterChain;
import org.apache.mina.transport.vmpipe.support.VmPipeIdleStatusChecker;
import org.apache.mina.util.ExceptionUtil;
import org.apache.mina.util.Queue;

public class VmPipeSessionImpl
extends BaseIoSession
implements VmPipeSession {
    private final IoSessionManager manager;
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final IoHandler handler;
    private final VmPipeFilterChain filterChain;
    final VmPipeSessionImpl remoteSession;
    final Object lock;
    final Queue pendingDataQueue;

    public VmPipeSessionImpl(IoSessionManager manager, Object lock, SocketAddress localAddress, IoHandler handler, IoFilterChainBuilder filterChainBuilder, VmPipe remoteEntry) throws IOException {
        this.manager = manager;
        this.lock = lock;
        this.localAddress = localAddress;
        this.remoteAddress = remoteEntry.getAddress();
        this.handler = handler;
        this.filterChain = new VmPipeFilterChain(this);
        this.pendingDataQueue = new Queue();
        this.remoteSession = new VmPipeSessionImpl(manager, this, remoteEntry);
        try {
            remoteEntry.getAcceptor().getFilterChainBuilder().buildFilterChain(this.remoteSession.getFilterChain());
            remoteEntry.getFilterChainBuilder().buildFilterChain(this.remoteSession.getFilterChain());
            ((VmPipeFilterChain)this.remoteSession.getFilterChain()).sessionCreated(this.remoteSession);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
            IOException e = new IOException("Failed to initialize remote session.");
            e.initCause(t);
            throw e;
        }
        try {
            manager.getFilterChainBuilder().buildFilterChain(this.remoteSession.getFilterChain());
            filterChainBuilder.buildFilterChain(this.remoteSession.getFilterChain());
            handler.sessionCreated(this);
        }
        catch (Throwable t) {
            ExceptionUtil.throwException(t);
        }
        VmPipeIdleStatusChecker.getInstance().addSession(this.remoteSession);
        VmPipeIdleStatusChecker.getInstance().addSession(this);
        ((VmPipeFilterChain)this.remoteSession.getFilterChain()).sessionOpened(this.remoteSession);
        this.filterChain.sessionOpened(this);
    }

    private VmPipeSessionImpl(IoSessionManager manager, VmPipeSessionImpl remoteSession, VmPipe entry) {
        this.manager = manager;
        this.lock = remoteSession.lock;
        this.localAddress = remoteSession.remoteAddress;
        this.remoteAddress = remoteSession.localAddress;
        this.handler = entry.getHandler();
        this.filterChain = new VmPipeFilterChain(this);
        this.remoteSession = remoteSession;
        this.pendingDataQueue = new Queue();
    }

    public IoSessionManager getManager() {
        return this.manager;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    public ProtocolEncoder getEncoder() {
        return null;
    }

    public ProtocolDecoder getDecoder() {
        return null;
    }

    protected void close0(CloseFuture closeFuture) {
        this.filterChain.filterClose(this, closeFuture);
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.filterWrite(this, writeRequest);
    }

    public int getScheduledWriteRequests() {
        return 0;
    }

    public TransportType getTransportType() {
        return TransportType.VM_PIPE;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTrafficMask() {
        if (this.getTrafficMask().isReadable() || this.getTrafficMask().isWritable()) {
            Object[] data = null;
            Queue queue = this.pendingDataQueue;
            synchronized (queue) {
                data = this.pendingDataQueue.toArray();
                this.pendingDataQueue.clear();
            }
            for (int i = 0; i < data.length; ++i) {
                if (data[i] instanceof IoFilter.WriteRequest) {
                    IoFilter.WriteRequest wr = (IoFilter.WriteRequest)data[i];
                    this.filterChain.doWrite(this, wr);
                    continue;
                }
                this.filterChain.messageReceived(this, data[i]);
            }
        }
    }
}

