/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AggregateSnapshot;
import dk.cloudcreate.essentials.shared.FailFast;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public interface AggregateSnapshotDeletionStrategy {
    public static AggregateSnapshotDeletionStrategy keepALimitedNumberOfHistoricSnapshots(long numberOfHistoricSnapshotsToKeep) {
        return KeepHistoricSnapshots.keepALimitedNumberOfHistoricSnapshots(numberOfHistoricSnapshotsToKeep);
    }

    public static AggregateSnapshotDeletionStrategy keepAllHistoricSnapshots() {
        return KeepHistoricSnapshots.keepAllHistoricSnapshots();
    }

    public static AggregateSnapshotDeletionStrategy deleteAllHistoricSnapshots() {
        return new DeleteAllHistoricSnapshots();
    }

    public boolean requiresExistingSnapshotDetailsToDetermineWhichAggregateSnapshotsToDelete();

    public <ID, AGGREGATE_IMPL_TYPE> Stream<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> resolveSnapshotsToDelete(List<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> var1);

    public static class KeepHistoricSnapshots
    implements AggregateSnapshotDeletionStrategy {
        private final long numberOfHistoricSnapshotsToKeep;

        public KeepHistoricSnapshots() {
            this.numberOfHistoricSnapshotsToKeep = Long.MAX_VALUE;
        }

        public KeepHistoricSnapshots(long numberOfHistoricSnapshotsToKeep) {
            FailFast.requireTrue((numberOfHistoricSnapshotsToKeep >= 0L ? 1 : 0) != 0, (String)"numberOfHistoricSnapshotsToKeep must be >= 0");
            this.numberOfHistoricSnapshotsToKeep = numberOfHistoricSnapshotsToKeep;
        }

        public static KeepHistoricSnapshots keepALimitedNumberOfHistoricSnapshots(long numberOfHistoricSnapshotsToKeep) {
            return new KeepHistoricSnapshots(numberOfHistoricSnapshotsToKeep);
        }

        public static KeepHistoricSnapshots keepAllHistoricSnapshots() {
            return new KeepHistoricSnapshots();
        }

        @Override
        public boolean requiresExistingSnapshotDetailsToDetermineWhichAggregateSnapshotsToDelete() {
            return this.numberOfHistoricSnapshotsToKeep > 0L;
        }

        @Override
        public <ID, AGGREGATE_IMPL_TYPE> Stream<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> resolveSnapshotsToDelete(List<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> existingSnapshots) {
            if ((long)existingSnapshots.size() >= this.numberOfHistoricSnapshotsToKeep) {
                return existingSnapshots.stream().limit((long)existingSnapshots.size() - this.numberOfHistoricSnapshotsToKeep + 1L);
            }
            return Stream.empty();
        }

        public long getNumberOfHistoricSnapshotsToKeep() {
            return this.numberOfHistoricSnapshotsToKeep;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeepHistoricSnapshots that = (KeepHistoricSnapshots)o;
            return this.numberOfHistoricSnapshotsToKeep == that.numberOfHistoricSnapshotsToKeep;
        }

        public int hashCode() {
            return Objects.hash(this.numberOfHistoricSnapshotsToKeep);
        }

        public String toString() {
            if (this.numberOfHistoricSnapshotsToKeep == Long.MAX_VALUE) {
                return "KeepAllHistoricSnapshots";
            }
            return "KeepALimitedNumberOfHistoricSnapshots(" + this.numberOfHistoricSnapshotsToKeep + ")";
        }
    }

    public static class DeleteAllHistoricSnapshots
    implements AggregateSnapshotDeletionStrategy {
        public String toString() {
            return "DeleteAllHistoricSnapshots";
        }

        @Override
        public boolean requiresExistingSnapshotDetailsToDetermineWhichAggregateSnapshotsToDelete() {
            return false;
        }

        @Override
        public <ID, AGGREGATE_IMPL_TYPE> Stream<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> resolveSnapshotsToDelete(List<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> existingSnapshots) {
            return existingSnapshots.stream();
        }
    }
}

