/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.decider;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.List;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HandlerResult<ERROR, EVENT> {
    public boolean isError();

    default public boolean isSuccess() {
        return !this.isError();
    }

    default public Success<ERROR, EVENT> asSuccess() {
        if (this.isSuccess()) {
            return (Success)this;
        }
        throw new IllegalStateException(MessageFormatter.msg((String)"Can't convert an error to a success. Error: {}", (Object[])new Object[]{this.asError()}));
    }

    default public Error<ERROR, EVENT> asError() {
        if (this.isError()) {
            return (Error)this;
        }
        throw new IllegalStateException(MessageFormatter.msg((String)"Can't convert an success to an error. Success: {}", (Object[])new Object[]{this.asSuccess()}));
    }

    default public void shouldSucceedWith(EVENT ... events) {
        this.shouldSucceedWith(List.of(events));
    }

    default public void shouldSucceedWith(List<EVENT> events) {
        if (this.isError()) {
            throw new IllegalStateException(MessageFormatter.msg((String)"Expected a success, but was a failure: {}", (Object[])new Object[]{this.asError().error}));
        }
        if (!Objects.equals(this.asSuccess().events, events)) {
            throw new IllegalStateException(MessageFormatter.msg((String)"Expected events {}, but received events: {}", (Object[])new Object[]{this.asSuccess().events, events}));
        }
    }

    default public void shouldFailWith(ERROR error) {
        if (this.isSuccess()) {
            throw new IllegalStateException(MessageFormatter.msg((String)"Expected a failure, but was a success: {}", (Object[])new Object[]{this.asSuccess().events}));
        }
        if (!Objects.equals(this.asError().error, error)) {
            throw new IllegalStateException(MessageFormatter.msg((String)"Expected error {}, but received error: {}", (Object[])new Object[]{this.asError().error, error}));
        }
    }

    public static <EVENT, ERROR> Error<ERROR, EVENT> error(ERROR error) {
        FailFast.requireNonNull(error, (String)"No error provided");
        return new Error(error);
    }

    public static <EVENT, ERROR> Success<ERROR, EVENT> events(EVENT ... events) {
        return new Success(events);
    }

    public static <EVENT, ERROR> Success<ERROR, EVENT> events(List<EVENT> events) {
        return new Success(events);
    }

    public record Success<ERROR, EVENT>(List<EVENT> events) implements HandlerResult<ERROR, EVENT>
    {
        public Success {
            FailFast.requireNonNull(events, (String)"events list was null");
        }

        public Success(EVENT ... events) {
            this(List.of(events));
        }

        @Override
        public boolean isError() {
            return false;
        }
    }

    public record Error<ERROR, EVENT>(ERROR error) implements HandlerResult<ERROR, EVENT>
    {
        public Error {
            FailFast.requireNonNull(error, (String)"No error provided");
        }

        @Override
        public boolean isError() {
            return true;
        }
    }
}

