/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AggregateSnapshot;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AggregateSnapshotRepository;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateType;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.PersistedEvent;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.collections.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedAddAndDeleteAggregateSnapshotDelegate
implements AggregateSnapshotRepository {
    private static final Logger log = LoggerFactory.getLogger(DelayedAddAndDeleteAggregateSnapshotDelegate.class);
    private final AggregateSnapshotRepository delegateRepository;

    public static AggregateSnapshotRepository delegateTo(AggregateSnapshotRepository delegateRepository) {
        return new DelayedAddAndDeleteAggregateSnapshotDelegate(delegateRepository);
    }

    public DelayedAddAndDeleteAggregateSnapshotDelegate(AggregateSnapshotRepository delegateRepository) {
        this.delegateRepository = (AggregateSnapshotRepository)FailFast.requireNonNull((Object)delegateRepository, (String)"No delegateRepository provided");
        log.info("Delegating to {}", (Object)delegateRepository);
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> Optional<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> loadSnapshot(AggregateType aggregateType, ID aggregateId, Class<AGGREGATE_IMPL_TYPE> aggregateImplType) {
        return this.delegateRepository.loadSnapshot(aggregateType, aggregateId, aggregateImplType);
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> Optional<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> loadSnapshot(AggregateType aggregateType, ID aggregateId, EventOrder withLastIncludedEventOrderLessThanOrEqualTo, Class<AGGREGATE_IMPL_TYPE> aggregateImplType) {
        return this.delegateRepository.loadSnapshot(aggregateType, aggregateId, withLastIncludedEventOrderLessThanOrEqualTo, aggregateImplType);
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> List<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> loadAllSnapshots(AggregateType aggregateType, ID aggregateId, Class<AGGREGATE_IMPL_TYPE> aggregateImplType, boolean includeSnapshotPayload) {
        return this.delegateRepository.loadAllSnapshots(aggregateType, aggregateId, aggregateImplType, includeSnapshotPayload);
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> void aggregateUpdated(AGGREGATE_IMPL_TYPE aggregate, AggregateEventStream<ID> persistedEvents) {
        CompletableFuture.runAsync(() -> {
            log.debug("[{}:{}] Delegating aggregateUpdated for '{}' and last_included_event_order {}", new Object[]{persistedEvents.aggregateType(), persistedEvents.aggregateId(), aggregate.getClass().getName(), ((PersistedEvent)Lists.last((List)persistedEvents.eventList()).get()).eventOrder()});
            this.delegateRepository.aggregateUpdated(aggregate, persistedEvents);
        });
    }

    @Override
    public <AGGREGATE_IMPL_TYPE> void deleteAllSnapshots(Class<AGGREGATE_IMPL_TYPE> ofAggregateImplementationType) {
        this.delegateRepository.deleteAllSnapshots(ofAggregateImplementationType);
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> void deleteSnapshots(AggregateType aggregateType, ID aggregateId, Class<AGGREGATE_IMPL_TYPE> withAggregateImplementationType) {
        this.delegateRepository.deleteSnapshots(aggregateType, aggregateId, withAggregateImplementationType);
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> void deleteSnapshots(AggregateType aggregateType, ID aggregateId, Class<AGGREGATE_IMPL_TYPE> withAggregateImplementationType, List<EventOrder> snapshotEventOrdersToDelete) {
        CompletableFuture.runAsync(() -> {
            log.debug("[{}:{}] Delegating deleteSnapshots for '{}' and snapshotEventOrdersToDelete: {}", new Object[]{aggregateType, aggregateId, withAggregateImplementationType.getName(), snapshotEventOrdersToDelete});
            this.delegateRepository.deleteSnapshots(aggregateType, aggregateId, withAggregateImplementationType, snapshotEventOrdersToDelete);
        });
    }
}

