/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventHandler;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventsToPersist;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.StatefulAggregate;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.Event;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.InitialEventIsMissingAggregateIdException;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.reflection.invocation.InvocationStrategy;
import dk.cloudcreate.essentials.shared.reflection.invocation.MethodPatternMatcher;
import dk.cloudcreate.essentials.shared.reflection.invocation.PatternMatchingMethodInvoker;
import dk.cloudcreate.essentials.shared.reflection.invocation.SingleArgumentAnnotatedMethodPatternMatcher;
import dk.cloudcreate.essentials.shared.types.GenericType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class AggregateRoot<ID, EVENT_TYPE extends Event<ID>, AGGREGATE_TYPE extends AggregateRoot<ID, EVENT_TYPE, AGGREGATE_TYPE>>
implements StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_TYPE> {
    private transient PatternMatchingMethodInvoker<Event<ID>> invoker;
    private ID aggregateId;
    private List<EVENT_TYPE> uncommittedChanges;
    private EventOrder eventOrderOfLastAppliedEvent;
    private boolean hasBeenRehydrated;
    private boolean isRehydrating;
    private EventOrder eventOrderOfLastRehydratedEvent;

    public AggregateRoot() {
        this.initialize();
    }

    protected void initialize() {
        this.invoker = new PatternMatchingMethodInvoker((Object)this, (MethodPatternMatcher)new SingleArgumentAnnotatedMethodPatternMatcher(EventHandler.class, new GenericType<Event<ID>>(){}), InvocationStrategy.InvokeMostSpecificTypeMatched);
    }

    @Override
    public AGGREGATE_TYPE rehydrate(AggregateEventStream<ID> persistedEvents) {
        FailFast.requireNonNull(persistedEvents, (String)"You must provide a persistedEvents stream");
        return this.rehydrate(persistedEvents.map(persistedEvent -> (Event)persistedEvent.event().deserialize()));
    }

    @Override
    public AGGREGATE_TYPE rehydrate(Stream<EVENT_TYPE> previousEvents) {
        FailFast.requireNonNull(previousEvents, (String)"You must provide a previousEvents stream");
        this.isRehydrating = true;
        previousEvents.forEach(event -> {
            if (this.aggregateId == null) {
                this.aggregateId = event.aggregateId();
                FailFast.requireNonNull(this.aggregateId, (String)MessageFormatter.msg((String)"The first previous/historic Event '{}' applied to Aggregate '{}' didn't contain an aggregateId", (Object[])new Object[]{event.getClass().getName(), this.getClass().getName()}));
            }
            this.applyEventToTheAggregateState((Event<ID>)event);
            this.eventOrderOfLastAppliedEvent = event.eventOrder();
        });
        this.eventOrderOfLastRehydratedEvent = this.eventOrderOfLastAppliedEvent;
        this.isRehydrating = false;
        this.hasBeenRehydrated = true;
        return (AGGREGATE_TYPE)this;
    }

    @Override
    public EventOrder eventOrderOfLastRehydratedEvent() {
        return this.eventOrderOfLastRehydratedEvent;
    }

    protected void apply(EVENT_TYPE event) {
        FailFast.requireNonNull(event, (String)"You must supply an event");
        Object eventAggregateId = ((Event)event).aggregateId();
        if (this.aggregateId == null) {
            this.aggregateId = eventAggregateId;
            if (this.aggregateId == null) {
                throw new InitialEventIsMissingAggregateIdException(MessageFormatter.msg((String)"The first Event '{}' applied to Aggregate '{}' didn't contain an aggregateId", (Object[])new Object[]{event.getClass().getName(), this.getClass().getName()}));
            }
        }
        if (eventAggregateId == null) {
            ((Event)event).aggregateId(this.aggregateId());
        } else {
            FailFast.requireTrue((boolean)Objects.equals(eventAggregateId, this.aggregateId), (String)MessageFormatter.msg((String)"Aggregate Id's do not match! Cannot apply Event '{}' with aggregateId '{}' to Aggregate '{}' with aggregateId '{}'", (Object[])new Object[]{event.getClass().getName(), eventAggregateId, this.getClass().getName(), this.aggregateId}));
        }
        EventOrder nextEventOrderToBeApplied = this.eventOrderOfLastAppliedEvent().increment();
        ((Event)event).eventOrder(nextEventOrderToBeApplied);
        this.applyEventToTheAggregateState((Event<ID>)event);
        this.eventOrderOfLastAppliedEvent = nextEventOrderToBeApplied;
        this._uncommittedChanges().add(event);
    }

    @Override
    public ID aggregateId() {
        FailFast.requireNonNull(this.aggregateId, (String)"The aggregate id has not been set on the AggregateRoot and not supplied using one of the Event applied to it. At least the first event MUST supply it");
        return this.aggregateId;
    }

    @Override
    public boolean hasBeenRehydrated() {
        return this.hasBeenRehydrated;
    }

    protected final boolean isRehydrating() {
        return this.isRehydrating;
    }

    protected void applyEventToTheAggregateState(Event<ID> event) {
        if (this.invoker == null) {
            this.initialize();
        }
        this.invoker.invoke(event, unmatchedEvent -> {});
    }

    public EventOrder eventOrderOfLastAppliedEvent() {
        if (this.eventOrderOfLastAppliedEvent == null) {
            this.eventOrderOfLastAppliedEvent = EventOrder.NO_EVENTS_PERSISTED;
        }
        return this.eventOrderOfLastAppliedEvent;
    }

    @Override
    public EventsToPersist<ID, EVENT_TYPE> getUncommittedChanges() {
        return new EventsToPersist<ID, EVENT_TYPE>(this.aggregateId, this.eventOrderOfLastRehydratedEvent, this._uncommittedChanges());
    }

    @Override
    public void markChangesAsCommitted() {
        this.uncommittedChanges = new ArrayList<EVENT_TYPE>();
    }

    private List<EVENT_TYPE> _uncommittedChanges() {
        if (this.uncommittedChanges == null) {
            this.uncommittedChanges = new ArrayList<EVENT_TYPE>();
        }
        return this.uncommittedChanges;
    }
}

