/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot;

import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.PersistedEvent;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.collections.Lists;
import dk.cloudcreate.essentials.types.NumberType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface AddNewAggregateSnapshotStrategy {
    public static AddNewAggregateSnapshotStrategy updateWhenBehindByNumberOfEvents(long numberOfEvents) {
        return new AddNewSnapshotWhenBehindByNumberOfEvents(numberOfEvents);
    }

    public static AddNewAggregateSnapshotStrategy updateOnEachAggregateUpdate() {
        return new AddNewSnapshotWhenBehindByNumberOfEvents(1L);
    }

    public <ID, AGGREGATE_IMPL_TYPE> boolean shouldANewAggregateSnapshotBeAdded(AGGREGATE_IMPL_TYPE var1, AggregateEventStream<ID> var2, Optional<EventOrder> var3);

    public static class AddNewSnapshotWhenBehindByNumberOfEvents
    implements AddNewAggregateSnapshotStrategy {
        private final long numberOfEventsBetweenAddingANewSnapshot;

        public AddNewSnapshotWhenBehindByNumberOfEvents(long numberOfEventsBetweenAddingANewSnapshot) {
            FailFast.requireTrue((numberOfEventsBetweenAddingANewSnapshot >= 1L ? 1 : 0) != 0, (String)"numberOfEventsBetweenAddingANewSnapshot must be >= 1");
            this.numberOfEventsBetweenAddingANewSnapshot = numberOfEventsBetweenAddingANewSnapshot;
        }

        public long getNumberOfEventsBetweenAddingANewSnapshot() {
            return this.numberOfEventsBetweenAddingANewSnapshot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddNewSnapshotWhenBehindByNumberOfEvents that = (AddNewSnapshotWhenBehindByNumberOfEvents)o;
            return this.numberOfEventsBetweenAddingANewSnapshot == that.numberOfEventsBetweenAddingANewSnapshot;
        }

        public int hashCode() {
            return Objects.hash(this.numberOfEventsBetweenAddingANewSnapshot);
        }

        public String toString() {
            if (this.numberOfEventsBetweenAddingANewSnapshot == 1L) {
                return "AddNewAggregateSnapshotOnEachAggregateUpdate";
            }
            return "AddNewSnapshotWhenBehindByNumberOfEvents(" + this.numberOfEventsBetweenAddingANewSnapshot + ")";
        }

        @Override
        public <ID, AGGREGATE_IMPL_TYPE> boolean shouldANewAggregateSnapshotBeAdded(AGGREGATE_IMPL_TYPE aggregate, AggregateEventStream<ID> persistedEvents, Optional<EventOrder> mostRecentlyStoredSnapshotLastIncludedEventOrder) {
            return ((PersistedEvent)Lists.last((List)persistedEvents.eventList()).get()).eventOrder().longValue() - mostRecentlyStoredSnapshotLastIncludedEventOrder.map(NumberType::longValue).orElse(-1L) >= this.numberOfEventsBetweenAddingANewSnapshot;
        }
    }
}

