/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventsToPersist;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.OptimisticAggregateLoadException;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AggregateSnapshot;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AggregateSnapshotRepository;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.BrokenSnapshot;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.StatefulAggregate;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.StatefulAggregateInMemoryProjector;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.StatefulAggregateInstanceFactory;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.AggregateNotFoundException;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.ConfigurableEventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.EventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.InMemoryProjector;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateType;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.PersistedEvent;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.persistence.AggregateEventStreamConfiguration;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.transaction.EventStoreUnitOfWork;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkLifecycleCallback;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.types.GenericType;
import dk.cloudcreate.essentials.types.LongRange;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>> {
    public static <CONFIG extends AggregateEventStreamConfiguration, ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>> StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, CONFIG eventStreamConfiguration, StatefulAggregateInstanceFactory aggregateRootInstanceFactory, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType) {
        FailFast.requireNonNull(aggregateImplementationType, (String)"No aggregateImplementationType provided");
        return new DefaultStatefulAggregateRepository(eventStore, eventStreamConfiguration, aggregateRootInstanceFactory, GenericType.resolveGenericTypeOnSuperClass(aggregateImplementationType, (int)0), aggregateImplementationType, null);
    }

    public static <CONFIG extends AggregateEventStreamConfiguration, ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>> StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, CONFIG eventStreamConfiguration, StatefulAggregateInstanceFactory aggregateRootInstanceFactory, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType, AggregateSnapshotRepository aggregateSnapshotRepository) {
        FailFast.requireNonNull(aggregateImplementationType, (String)"No aggregateImplementationType provided");
        return new DefaultStatefulAggregateRepository(eventStore, eventStreamConfiguration, aggregateRootInstanceFactory, GenericType.resolveGenericTypeOnSuperClass(aggregateImplementationType, (int)0), aggregateImplementationType, aggregateSnapshotRepository);
    }

    public static <CONFIG extends AggregateEventStreamConfiguration, ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>> StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, AggregateType aggregateType, StatefulAggregateInstanceFactory aggregateRootInstanceFactory, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType) {
        FailFast.requireNonNull(aggregateImplementationType, (String)"No aggregateImplementationType provided");
        return new DefaultStatefulAggregateRepository(eventStore, aggregateType, aggregateRootInstanceFactory, GenericType.resolveGenericTypeOnSuperClass(aggregateImplementationType, (int)0), aggregateImplementationType, null);
    }

    public static <CONFIG extends AggregateEventStreamConfiguration, ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>> StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, AggregateType aggregateType, StatefulAggregateInstanceFactory aggregateRootInstanceFactory, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType, AggregateSnapshotRepository aggregateSnapshotRepository) {
        FailFast.requireNonNull(aggregateImplementationType, (String)"No aggregateImplementationType provided");
        return new DefaultStatefulAggregateRepository(eventStore, aggregateType, aggregateRootInstanceFactory, GenericType.resolveGenericTypeOnSuperClass(aggregateImplementationType, (int)0), aggregateImplementationType, aggregateSnapshotRepository);
    }

    public static <CONFIG extends AggregateEventStreamConfiguration, ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>> StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, CONFIG eventStreamConfiguration, StatefulAggregateInstanceFactory aggregateRootInstanceFactory, Class<ID> aggregateIdType, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType) {
        return new DefaultStatefulAggregateRepository(eventStore, eventStreamConfiguration, aggregateRootInstanceFactory, aggregateIdType, aggregateImplementationType, null);
    }

    public static <CONFIG extends AggregateEventStreamConfiguration, ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>> StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, CONFIG eventStreamConfiguration, StatefulAggregateInstanceFactory aggregateRootInstanceFactory, Class<ID> aggregateIdType, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType, AggregateSnapshotRepository aggregateSnapshotRepository) {
        return new DefaultStatefulAggregateRepository(eventStore, eventStreamConfiguration, aggregateRootInstanceFactory, aggregateIdType, aggregateImplementationType, aggregateSnapshotRepository);
    }

    public static <CONFIG extends AggregateEventStreamConfiguration, ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>> StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, AggregateType aggregateType, StatefulAggregateInstanceFactory aggregateRootInstanceFactory, Class<ID> aggregateIdType, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType) {
        return new DefaultStatefulAggregateRepository(eventStore, aggregateType, aggregateRootInstanceFactory, aggregateIdType, aggregateImplementationType, null);
    }

    public static <CONFIG extends AggregateEventStreamConfiguration, ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>> StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, AggregateType aggregateType, StatefulAggregateInstanceFactory aggregateRootInstanceFactory, Class<ID> aggregateIdType, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType, AggregateSnapshotRepository aggregateSnapshotRepository) {
        return new DefaultStatefulAggregateRepository(eventStore, aggregateType, aggregateRootInstanceFactory, aggregateIdType, aggregateImplementationType, aggregateSnapshotRepository);
    }

    default public Optional<AGGREGATE_IMPL_TYPE> tryLoad(ID aggregateId, EventOrder expectedLatestEventOrder) {
        return this.tryLoad(aggregateId, Optional.of(expectedLatestEventOrder));
    }

    public Optional<AGGREGATE_IMPL_TYPE> tryLoad(ID var1, Optional<EventOrder> var2);

    default public Optional<AGGREGATE_IMPL_TYPE> tryLoad(ID aggregateId) {
        return this.tryLoad(aggregateId, Optional.empty());
    }

    default public AGGREGATE_IMPL_TYPE load(ID aggregateId) {
        return (AGGREGATE_IMPL_TYPE)((StatefulAggregate)this.tryLoad(aggregateId).orElseThrow(() -> new AggregateNotFoundException(aggregateId, this.aggregateRootImplementationType(), this.aggregateType())));
    }

    default public AGGREGATE_IMPL_TYPE load(ID aggregateId, EventOrder expectedLatestEventOrder) {
        return (AGGREGATE_IMPL_TYPE)((StatefulAggregate)this.tryLoad(aggregateId, expectedLatestEventOrder).orElseThrow(() -> new AggregateNotFoundException(aggregateId, this.aggregateRootImplementationType(), this.aggregateType())));
    }

    public AGGREGATE_IMPL_TYPE save(AGGREGATE_IMPL_TYPE var1);

    @Deprecated
    default public void persist(AGGREGATE_IMPL_TYPE aggregate) {
        this.save(aggregate);
    }

    public Class<ID> aggregateIdType();

    public Class<AGGREGATE_IMPL_TYPE> aggregateRootImplementationType();

    public AggregateType aggregateType();

    public static class DefaultStatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE extends StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE>>
    implements StatefulAggregateRepository<ID, EVENT_TYPE, AGGREGATE_IMPL_TYPE> {
        private static final Logger log = LoggerFactory.getLogger(StatefulAggregateRepository.class);
        private final EventStore eventStore;
        private final Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType;
        private final Class<ID> aggregateIdType;
        private final StatefulAggregateRepositoryUnitOfWorkLifecycleCallback unitOfWorkCallback;
        private final StatefulAggregateInstanceFactory aggregateRootInstanceFactory;
        private final AggregateType aggregateType;
        private final Optional<AggregateSnapshotRepository> aggregateSnapshotRepository;

        private <CONFIG extends AggregateEventStreamConfiguration> DefaultStatefulAggregateRepository(ConfigurableEventStore<CONFIG> eventStore, CONFIG aggregateEventStreamConfiguration, StatefulAggregateInstanceFactory statefulAggregateInstanceFactory, Class<ID> aggregateIdType, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType, AggregateSnapshotRepository aggregateSnapshotRepository) {
            this.eventStore = (EventStore)FailFast.requireNonNull(eventStore, (String)"You must supply an EventStore instance");
            this.aggregateType = ((AggregateEventStreamConfiguration)FailFast.requireNonNull(aggregateEventStreamConfiguration, (String)"You must supply an aggregateType")).aggregateType;
            this.aggregateRootInstanceFactory = (StatefulAggregateInstanceFactory)FailFast.requireNonNull((Object)statefulAggregateInstanceFactory, (String)"You must supply a AggregateRootFactory instance");
            this.aggregateImplementationType = (Class)FailFast.requireNonNull(aggregateImplementationType, (String)"You must supply an aggregateImplementationType");
            this.aggregateIdType = (Class)FailFast.requireNonNull(aggregateIdType, (String)"You must supply an aggregateIdType");
            this.aggregateSnapshotRepository = Optional.ofNullable(aggregateSnapshotRepository);
            this.unitOfWorkCallback = new StatefulAggregateRepositoryUnitOfWorkLifecycleCallback();
            eventStore.addAggregateEventStreamConfiguration(aggregateEventStreamConfiguration);
            eventStore.addSpecificInMemoryProjector(aggregateImplementationType, (InMemoryProjector)new StatefulAggregateInMemoryProjector(statefulAggregateInstanceFactory));
        }

        private <CONFIG extends AggregateEventStreamConfiguration> DefaultStatefulAggregateRepository(ConfigurableEventStore<CONFIG> eventStore, AggregateType aggregateType, StatefulAggregateInstanceFactory statefulAggregateInstanceFactory, Class<ID> aggregateIdType, Class<AGGREGATE_IMPL_TYPE> aggregateImplementationType, AggregateSnapshotRepository aggregateSnapshotRepository) {
            this.eventStore = (EventStore)FailFast.requireNonNull(eventStore, (String)"You must supply an EventStore instance");
            this.aggregateType = (AggregateType)FailFast.requireNonNull((Object)aggregateType, (String)"You must supply an aggregateType");
            this.aggregateRootInstanceFactory = (StatefulAggregateInstanceFactory)FailFast.requireNonNull((Object)statefulAggregateInstanceFactory, (String)"You must supply a AggregateRootFactory instance");
            this.aggregateImplementationType = (Class)FailFast.requireNonNull(aggregateImplementationType, (String)"You must supply an aggregateImplementationType");
            this.aggregateIdType = (Class)FailFast.requireNonNull(aggregateIdType, (String)"You must supply an aggregateIdType");
            this.aggregateSnapshotRepository = Optional.ofNullable(aggregateSnapshotRepository);
            this.unitOfWorkCallback = new StatefulAggregateRepositoryUnitOfWorkLifecycleCallback();
            if (eventStore.findAggregateEventStreamConfiguration(aggregateType).isEmpty()) {
                eventStore.addAggregateEventStreamConfiguration(aggregateType, aggregateIdType);
            }
            eventStore.addSpecificInMemoryProjector(aggregateImplementationType, (InMemoryProjector)new StatefulAggregateInMemoryProjector(statefulAggregateInstanceFactory));
        }

        protected EventStore eventStore() {
            return this.eventStore;
        }

        public String toString() {
            return "AggregateRootRepository{aggregateType=" + this.aggregateType + "aggregateImplementationType=" + this.aggregateRootImplementationType() + "aggregateIdType=" + this.aggregateIdType() + "}";
        }

        @Override
        public Optional<AGGREGATE_IMPL_TYPE> tryLoad(ID aggregateId, Optional<EventOrder> expectedLatestEventOrder) {
            PersistedEvent lastEventPersisted;
            log.trace("Trying to load {} with id '{}' and expectedLatestEventOrder {}", new Object[]{this.aggregateImplementationType.getName(), aggregateId, expectedLatestEventOrder});
            EventStoreUnitOfWork unitOfWork = (EventStoreUnitOfWork)this.eventStore.getUnitOfWorkFactory().getRequiredUnitOfWork();
            Optional<Object> aggregateSnapshot = this.aggregateSnapshotRepository.flatMap(repository -> repository.loadSnapshot(this.aggregateType, aggregateId, this.aggregateRootImplementationType()));
            if (aggregateSnapshot.isPresent() && ((AggregateSnapshot)aggregateSnapshot.get()).aggregateSnapshot instanceof BrokenSnapshot) {
                log.debug("[{}:{}] Broken '{}' SNAPSHOT with eventOrderOfLastIncludedEvent: {}", new Object[]{this.aggregateType, aggregateId, this.aggregateImplementationType.getName(), ((AggregateSnapshot)aggregateSnapshot.get()).eventOrderOfLastIncludedEvent});
                this.aggregateSnapshotRepository.get().deleteSnapshots(this.aggregateType, aggregateId, this.aggregateImplementationType, List.of(((AggregateSnapshot)aggregateSnapshot.get()).eventOrderOfLastIncludedEvent));
            }
            long loadMoreEventsWithEventOrderFromAndIncluding = aggregateSnapshot.map(snapshot -> {
                EventOrder nextEventOrder = snapshot.eventOrderOfLastIncludedEvent.increment();
                log.debug("[{}:{}] Using '{}' SNAPSHOT (globalEventOrderOfLastIncludedEvent + 1) as loadFromEventOrder: {}", new Object[]{this.aggregateType, aggregateId, this.aggregateImplementationType.getName(), nextEventOrder});
                return nextEventOrder.longValue();
            }).orElse(EventOrder.FIRST_EVENT_ORDER.longValue());
            log.debug("Loading [{}:{}] of aggregate-implementation-type '{}' using loadMoreEventsWithEventOrderFromAndIncluding: {}", new Object[]{this.aggregateType, aggregateId, this.aggregateImplementationType.getName(), loadMoreEventsWithEventOrderFromAndIncluding});
            Optional potentialPersistedEventStream = this.eventStore.fetchStream(this.aggregateType, aggregateId, LongRange.from((long)loadMoreEventsWithEventOrderFromAndIncluding));
            if (aggregateSnapshot.isPresent() && potentialPersistedEventStream.isEmpty()) {
                log.trace("[{}:{}] Didn't find a any {} events persisted after eventOrder: {}. Has SNAPSHOT: {}", new Object[]{this.aggregateType, aggregateId, this.aggregateImplementationType.getName(), loadMoreEventsWithEventOrderFromAndIncluding, aggregateSnapshot.isPresent()});
                return aggregateSnapshot.map(snapshot -> {
                    log.trace("[{}:{}] Returning '{}' SNAPSHOT as it's up-to-date as of eventOrderOfLastIncludedEvent: {}", new Object[]{this.aggregateType, aggregateId, this.aggregateImplementationType.getName(), ((AggregateSnapshot)aggregateSnapshot.get()).eventOrderOfLastIncludedEvent});
                    return (StatefulAggregate)snapshot.aggregateSnapshot;
                });
            }
            if (aggregateSnapshot.isEmpty() && potentialPersistedEventStream.isEmpty()) {
                return Optional.empty();
            }
            AggregateEventStream persistedEventsStream = (AggregateEventStream)potentialPersistedEventStream.get();
            if (expectedLatestEventOrder.isPresent() && !(lastEventPersisted = (PersistedEvent)persistedEventsStream.eventList().get(persistedEventsStream.eventList().size() - 1)).eventOrder().equals((Object)expectedLatestEventOrder.get())) {
                log.trace("Found {} with id '{}' but expectedLatestEventOrder {} != actualLatestEventOrder {}", new Object[]{this.aggregateImplementationType.getName(), aggregateId, expectedLatestEventOrder.get(), lastEventPersisted.eventOrder()});
                throw new OptimisticAggregateLoadException(aggregateId, this.aggregateImplementationType, expectedLatestEventOrder.get(), lastEventPersisted.eventOrder());
            }
            log.debug("[{}:{}] Found '{}' with expectedLatestEventOrder: {}. Has SNAPSHOT: {}", new Object[]{this.aggregateIdType, aggregateId, this.aggregateImplementationType.getName(), expectedLatestEventOrder, aggregateSnapshot.isPresent()});
            StatefulAggregate aggregate = aggregateSnapshot.map(snapshot -> (StatefulAggregate)snapshot.aggregateSnapshot).orElseGet(() -> (StatefulAggregate)this.aggregateRootInstanceFactory.create(aggregateId, this.aggregateImplementationType));
            return Optional.of((StatefulAggregate)unitOfWork.registerLifecycleCallbackForResource((Object)((StatefulAggregate)aggregate.rehydrate(persistedEventsStream)), (UnitOfWorkLifecycleCallback)this.unitOfWorkCallback));
        }

        @Override
        public AGGREGATE_IMPL_TYPE save(AGGREGATE_IMPL_TYPE aggregate) {
            log.debug("Adding {} with id '{}' to the current UnitOfWork so it will be persisted at commit time", (Object)this.aggregateImplementationType.getName(), aggregate.aggregateId());
            ((EventStoreUnitOfWork)this.eventStore.getUnitOfWorkFactory().getRequiredUnitOfWork()).registerLifecycleCallbackForResource(aggregate, (UnitOfWorkLifecycleCallback)this.unitOfWorkCallback);
            return aggregate;
        }

        @Override
        public Class<ID> aggregateIdType() {
            return this.aggregateIdType;
        }

        @Override
        public Class<AGGREGATE_IMPL_TYPE> aggregateRootImplementationType() {
            return this.aggregateImplementationType;
        }

        @Override
        public AggregateType aggregateType() {
            return this.aggregateType;
        }

        private class StatefulAggregateRepositoryUnitOfWorkLifecycleCallback
        implements UnitOfWorkLifecycleCallback<AGGREGATE_IMPL_TYPE> {
            private StatefulAggregateRepositoryUnitOfWorkLifecycleCallback() {
            }

            public void beforeCommit(UnitOfWork unitOfWork, List<AGGREGATE_IMPL_TYPE> associatedResources) {
                log.trace("beforeCommit processing {} '{}' registered with the UnitOfWork being committed", (Object)associatedResources.size(), (Object)DefaultStatefulAggregateRepository.this.aggregateImplementationType.getName());
                associatedResources.forEach(aggregate -> {
                    log.trace("beforeCommit processing '{}' with id '{}'", (Object)DefaultStatefulAggregateRepository.this.aggregateImplementationType.getName(), aggregate.aggregateId());
                    EventsToPersist eventsToPersist = aggregate.getUncommittedChanges();
                    if (eventsToPersist.isEmpty()) {
                        log.trace("No changes detected for '{}' with id '{}'", (Object)DefaultStatefulAggregateRepository.this.aggregateImplementationType.getName(), aggregate.aggregateId());
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace("Persisting {} event(s) related to '{}' with id '{}': {}", new Object[]{eventsToPersist.events.size(), DefaultStatefulAggregateRepository.this.aggregateImplementationType.getName(), aggregate.aggregateId(), eventsToPersist.stream().map(persistableEvent -> persistableEvent.getClass().getName()).reduce((s, s2) -> s + ", " + s2)});
                        } else {
                            log.debug("Persisting {} event(s) related to '{}' with id '{}'", new Object[]{eventsToPersist.events.size(), DefaultStatefulAggregateRepository.this.aggregateImplementationType.getName(), aggregate.aggregateId()});
                        }
                        AggregateEventStream persistedEvents = DefaultStatefulAggregateRepository.this.eventStore.appendToStream(DefaultStatefulAggregateRepository.this.aggregateType, eventsToPersist.aggregateId, eventsToPersist.eventOrderOfLastRehydratedEvent, eventsToPersist.events);
                        aggregate.markChangesAsCommitted();
                        DefaultStatefulAggregateRepository.this.aggregateSnapshotRepository.ifPresent(repository -> repository.aggregateUpdated(aggregate, persistedEvents));
                    }
                });
            }

            public void afterCommit(UnitOfWork unitOfWork, List<AGGREGATE_IMPL_TYPE> associatedResources) {
            }

            public void beforeRollback(UnitOfWork unitOfWork, List<AGGREGATE_IMPL_TYPE> associatedResources, Exception causeOfTheRollback) {
            }

            public void afterRollback(UnitOfWork unitOfWork, List<AGGREGATE_IMPL_TYPE> associatedResources, Exception causeOfTheRollback) {
            }
        }
    }
}

