/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.modern;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.AggregateException;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventHandler;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventsToPersist;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.StatefulAggregate;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.modern.AggregateState;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.modern.WithState;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.reflection.Reflector;
import dk.cloudcreate.essentials.shared.reflection.invocation.InvocationStrategy;
import dk.cloudcreate.essentials.shared.reflection.invocation.MethodPatternMatcher;
import dk.cloudcreate.essentials.shared.reflection.invocation.PatternMatchingMethodInvoker;
import dk.cloudcreate.essentials.shared.reflection.invocation.SingleArgumentAnnotatedMethodPatternMatcher;
import dk.cloudcreate.essentials.shared.types.GenericType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public abstract class AggregateRoot<ID, EVENT_TYPE, AGGREGATE_TYPE extends AggregateRoot<ID, EVENT_TYPE, AGGREGATE_TYPE>>
implements StatefulAggregate<ID, EVENT_TYPE, AGGREGATE_TYPE> {
    private transient PatternMatchingMethodInvoker<Object> invoker;
    private ID aggregateId;
    private EventOrder eventOrderOfLastAppliedEvent = EventOrder.NO_EVENTS_PREVIOUSLY_PERSISTED;
    private List<EVENT_TYPE> uncommittedEvents;
    private EventOrder eventOrderOfLastRehydratedEvent = EventOrder.NO_EVENTS_PREVIOUSLY_PERSISTED;
    private boolean hasBeenRehydrated;
    private boolean isRehydrating;
    private AggregateState<ID, EVENT_TYPE, AGGREGATE_TYPE> state;

    protected AggregateRoot() {
        this.initialize();
    }

    public AggregateRoot(ID aggregateId) {
        this.aggregateId = aggregateId;
        this.initialize();
    }

    @Override
    public ID aggregateId() {
        return this.aggregateId;
    }

    @Override
    public EventsToPersist<ID, EVENT_TYPE> getUncommittedChanges() {
        return new EventsToPersist<ID, EVENT_TYPE>(this.aggregateId, this.eventOrderOfLastRehydratedEvent, this.uncommittedEvents);
    }

    @Override
    public void markChangesAsCommitted() {
        this.uncommittedEvents = new ArrayList<EVENT_TYPE>();
        this.eventOrderOfLastRehydratedEvent = null;
    }

    @Override
    public boolean hasBeenRehydrated() {
        return this.hasBeenRehydrated;
    }

    protected <STATE extends AggregateState<ID, EVENT_TYPE, AGGREGATE_TYPE>> STATE state(Class<STATE> stateClass) {
        return this.state();
    }

    protected <STATE extends AggregateState<ID, EVENT_TYPE, AGGREGATE_TYPE>> STATE state() {
        if (!WithState.class.isAssignableFrom(this.getClass())) {
            throw new AggregateException(MessageFormatter.msg((String)"Aggregate {} doesn't implement {}", (Object[])new Object[]{this.getClass().getName(), WithState.class.getSimpleName()}));
        }
        if (this.invoker == null) {
            this.initialize();
        }
        return (STATE)this.state;
    }

    protected void initialize() {
        this.uncommittedEvents = new ArrayList<EVENT_TYPE>();
        if (WithState.class.isAssignableFrom(this.getClass())) {
            if (this.state == null) {
                Class<?> aggregateStateType = this.resolveStateImplementationClass();
                this.state = (AggregateState)Reflector.reflectOn(aggregateStateType).newInstance(new Object[0]);
            }
            this.state.setAggregate(this);
            this.invoker = new PatternMatchingMethodInvoker(this.state, (MethodPatternMatcher)new SingleArgumentAnnotatedMethodPatternMatcher(EventHandler.class, (GenericType)new GenericType<Object>(){}), InvocationStrategy.InvokeMostSpecificTypeMatched);
        } else {
            this.invoker = new PatternMatchingMethodInvoker((Object)this, (MethodPatternMatcher)new SingleArgumentAnnotatedMethodPatternMatcher(EventHandler.class, (GenericType)new GenericType<Object>(){}), InvocationStrategy.InvokeMostSpecificTypeMatched);
        }
    }

    protected Class<?> resolveStateImplementationClass() {
        Class aggregateStateType = GenericType.resolveGenericTypeForInterface(this.getClass(), WithState.class, (int)3);
        return aggregateStateType;
    }

    @Override
    public AGGREGATE_TYPE rehydrate(AggregateEventStream<ID> persistedEvents) {
        FailFast.requireNonNull(persistedEvents, (String)"You must provide a persistedEvents stream");
        return this.rehydrate(persistedEvents.map(persistedEvent -> persistedEvent.event().deserialize()));
    }

    @Override
    public EventOrder eventOrderOfLastRehydratedEvent() {
        return this.eventOrderOfLastRehydratedEvent;
    }

    @Override
    public AGGREGATE_TYPE rehydrate(Stream<EVENT_TYPE> persistedEvents) {
        FailFast.requireNonNull(this.aggregateId, (String)"You must provide an aggregateId with the aggregate constructor");
        FailFast.requireNonNull(persistedEvents, (String)"You must provide a persistedEvents stream");
        this.isRehydrating = true;
        persistedEvents.forEach(event -> {
            this.applyEventToTheAggregateState(event);
            this.eventOrderOfLastAppliedEvent = this.eventOrderOfLastAppliedEvent().increment();
        });
        this.eventOrderOfLastRehydratedEvent = this.eventOrderOfLastAppliedEvent;
        this.isRehydrating = false;
        this.hasBeenRehydrated = true;
        return (AGGREGATE_TYPE)this;
    }

    protected void apply(Function<EventOrder, EVENT_TYPE> eventSupplier) {
        FailFast.requireNonNull(eventSupplier, (String)"No eventSupplier provided");
        EVENT_TYPE event = eventSupplier.apply(this.eventOrderOfLastAppliedEvent().increment());
        FailFast.requireNonNull(event, (String)"No event was returned from the eventSupplier");
        this.apply(event);
    }

    public EventOrder eventOrderOfLastAppliedEvent() {
        if (this.eventOrderOfLastAppliedEvent == null) {
            this.eventOrderOfLastAppliedEvent = EventOrder.NO_EVENTS_PREVIOUSLY_PERSISTED;
        }
        return this.eventOrderOfLastAppliedEvent;
    }

    protected void apply(EVENT_TYPE event) {
        FailFast.requireNonNull(event, (String)"You must supply an event");
        this.applyEventToTheAggregateState(event);
        this.uncommittedEvents.add(event);
        this.eventOrderOfLastAppliedEvent = this.eventOrderOfLastAppliedEvent().increment();
    }

    protected void applyEventToTheAggregateState(Object event) {
        if (this.invoker == null) {
            this.initialize();
        }
        this.invoker.invoke(event, unmatchedEvent -> {});
    }

    protected final boolean isRehydrating() {
        return this.isRehydrating;
    }
}

