/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.StatefulAggregate;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.StatefulAggregateInstanceFactory;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.AggregateRoot;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.EventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.InMemoryProjector;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateType;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.Optional;

public class StatefulAggregateInMemoryProjector
implements InMemoryProjector {
    private final StatefulAggregateInstanceFactory aggregateRootInstanceFactory;

    public StatefulAggregateInMemoryProjector(StatefulAggregateInstanceFactory aggregateRootInstanceFactory) {
        this.aggregateRootInstanceFactory = (StatefulAggregateInstanceFactory)FailFast.requireNonNull((Object)aggregateRootInstanceFactory, (String)"No aggregateRootFactory instance provided");
    }

    public boolean supports(Class<?> projectionType) {
        return AggregateRoot.class.isAssignableFrom((Class)FailFast.requireNonNull(projectionType, (String)"No aggregateType provided"));
    }

    public <ID, PROJECTION> Optional<PROJECTION> projectEvents(AggregateType aggregateType, ID aggregateId, Class<PROJECTION> projectionType, EventStore eventStore) {
        FailFast.requireNonNull((Object)aggregateType, (String)"No aggregateType provided");
        FailFast.requireNonNull(aggregateId, (String)"No aggregateId provided");
        FailFast.requireNonNull(projectionType, (String)"No aggregateType provided");
        FailFast.requireNonNull((Object)eventStore, (String)"No eventStore instance provided");
        if (!this.supports(projectionType)) {
            throw new IllegalArgumentException(MessageFormatter.msg((String)"The provided aggregateType '{}' isn't supported", (Object[])new Object[]{projectionType.getName()}));
        }
        StatefulAggregate aggregate = (StatefulAggregate)this.aggregateRootInstanceFactory.create(aggregateId, projectionType);
        Optional possibleEventStream = eventStore.fetchStream(aggregateType, aggregateId);
        return possibleEventStream.map(aggregate::rehydrate);
    }
}

