/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.flex;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventsToPersist;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.OptimisticAggregateLoadException;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.flex.FlexAggregate;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.AggregateNotFoundException;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.ConfigurableEventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.EventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateType;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.PersistedEvent;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.persistence.AggregateEventStreamConfiguration;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.transaction.EventStoreUnitOfWorkFactory;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkLifecycleCallback;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.reflection.Reflector;
import dk.cloudcreate.essentials.types.LongRange;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FlexAggregateRepository<ID, AGGREGATE_TYPE extends FlexAggregate<ID, AGGREGATE_TYPE>> {
    public static <CONFIG extends AggregateEventStreamConfiguration, ID, AGGREGATE_TYPE extends FlexAggregate<ID, AGGREGATE_TYPE>> FlexAggregateRepository<ID, AGGREGATE_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, CONFIG aggregateEventStreamConfiguration, EventStoreUnitOfWorkFactory unitOfWorkFactory, Class<ID> aggregateIdType, Class<AGGREGATE_TYPE> aggregateImplementationType) {
        return new DefaultFlexAggregateRepository<ID, AGGREGATE_TYPE>(eventStore, aggregateEventStreamConfiguration, unitOfWorkFactory, aggregateIdType, aggregateImplementationType);
    }

    public static <CONFIG extends AggregateEventStreamConfiguration, ID, AGGREGATE_TYPE extends FlexAggregate<ID, AGGREGATE_TYPE>> FlexAggregateRepository<ID, AGGREGATE_TYPE> from(ConfigurableEventStore<CONFIG> eventStore, AggregateType aggregateType, EventStoreUnitOfWorkFactory unitOfWorkFactory, Class<ID> aggregateIdType, Class<AGGREGATE_TYPE> aggregateImplementationType) {
        return new DefaultFlexAggregateRepository<ID, AGGREGATE_TYPE>(eventStore, aggregateType, unitOfWorkFactory, aggregateIdType, aggregateImplementationType);
    }

    default public Optional<AGGREGATE_TYPE> tryLoad(ID aggregateId, long expectedLatestEventOrder) {
        return this.tryLoad(aggregateId, Optional.of(expectedLatestEventOrder));
    }

    public Optional<AGGREGATE_TYPE> tryLoad(ID var1, Optional<Long> var2);

    default public Optional<AGGREGATE_TYPE> tryLoad(ID aggregateId) {
        return this.tryLoad(aggregateId, Optional.empty());
    }

    default public AGGREGATE_TYPE load(ID aggregateId) {
        return (AGGREGATE_TYPE)((FlexAggregate)this.tryLoad(aggregateId).orElseThrow(() -> new AggregateNotFoundException(aggregateId, this.aggregateRootImplementationType(), this.aggregateType())));
    }

    public Class<AGGREGATE_TYPE> aggregateRootImplementationType();

    public AggregateType aggregateType();

    default public AGGREGATE_TYPE load(ID aggregateId, long expectedLatestEventOrder) {
        return (AGGREGATE_TYPE)((FlexAggregate)this.tryLoad(aggregateId, expectedLatestEventOrder).orElseThrow(() -> new AggregateNotFoundException(aggregateId, this.aggregateRootImplementationType(), this.aggregateType())));
    }

    public void persist(EventsToPersist<ID, Object> var1);

    public Class<ID> aggregateIdType();

    public static class DefaultFlexAggregateRepository<ID, AGGREGATE_TYPE extends FlexAggregate<ID, AGGREGATE_TYPE>>
    implements FlexAggregateRepository<ID, AGGREGATE_TYPE> {
        private static final Logger log = LoggerFactory.getLogger(FlexAggregateRepository.class);
        private final EventStore eventStore;
        private final Class<AGGREGATE_TYPE> aggregateRootImplementationType;
        private final Class<ID> aggregateIdType;
        private final EventStoreUnitOfWorkFactory unitOfWorkFactory;
        private final FlexAggregateRepositoryUnitOfWorkLifecycleCallback unitOfWorkCallback;
        private final AggregateType aggregateType;

        private <CONFIG extends AggregateEventStreamConfiguration> DefaultFlexAggregateRepository(ConfigurableEventStore<CONFIG> eventStore, CONFIG aggregateEventStreamConfiguration, EventStoreUnitOfWorkFactory unitOfWorkFactory, Class<ID> aggregateIdType, Class<AGGREGATE_TYPE> aggregateRootImplementationType) {
            this.eventStore = (EventStore)FailFast.requireNonNull(eventStore, (String)"You must supply an EventStore instance");
            this.aggregateType = ((AggregateEventStreamConfiguration)FailFast.requireNonNull(aggregateEventStreamConfiguration, (String)"You must supply an aggregateType")).aggregateType;
            this.unitOfWorkFactory = (EventStoreUnitOfWorkFactory)FailFast.requireNonNull((Object)unitOfWorkFactory, (String)"You must supply a UnitOfWorkFactory instance");
            this.aggregateRootImplementationType = (Class)FailFast.requireNonNull(aggregateRootImplementationType, (String)"You must supply an aggregateImplementationType");
            this.aggregateIdType = (Class)FailFast.requireNonNull(aggregateIdType, (String)"You must supply an aggregateIdType");
            this.unitOfWorkCallback = new FlexAggregateRepositoryUnitOfWorkLifecycleCallback();
            eventStore.addAggregateEventStreamConfiguration(aggregateEventStreamConfiguration);
        }

        private <CONFIG extends AggregateEventStreamConfiguration> DefaultFlexAggregateRepository(ConfigurableEventStore<CONFIG> eventStore, AggregateType aggregateType, EventStoreUnitOfWorkFactory unitOfWorkFactory, Class<ID> aggregateIdType, Class<AGGREGATE_TYPE> aggregateRootImplementationType) {
            this.eventStore = (EventStore)FailFast.requireNonNull(eventStore, (String)"You must supply an EventStore instance");
            this.aggregateType = (AggregateType)FailFast.requireNonNull((Object)aggregateType, (String)"You must supply an aggregateType");
            this.unitOfWorkFactory = (EventStoreUnitOfWorkFactory)FailFast.requireNonNull((Object)unitOfWorkFactory, (String)"You must supply a UnitOfWorkFactory instance");
            this.aggregateRootImplementationType = (Class)FailFast.requireNonNull(aggregateRootImplementationType, (String)"You must supply an aggregateImplementationType");
            this.aggregateIdType = (Class)FailFast.requireNonNull(aggregateIdType, (String)"You must supply an aggregateIdType");
            this.unitOfWorkCallback = new FlexAggregateRepositoryUnitOfWorkLifecycleCallback();
            if (eventStore.findAggregateEventStreamConfiguration(aggregateType).isEmpty()) {
                eventStore.addAggregateEventStreamConfiguration(aggregateType, aggregateIdType);
            }
        }

        protected EventStore eventStore() {
            return this.eventStore;
        }

        @Override
        public AggregateType aggregateType() {
            return this.aggregateType;
        }

        public String toString() {
            return "FlexAggregateRepository{aggregateType=" + this.aggregateType() + ", aggregateIdType=" + this.aggregateIdType() + ", aggregateImplementationType=" + this.aggregateRootImplementationType().getName() + "}";
        }

        @Override
        public Optional<AGGREGATE_TYPE> tryLoad(ID aggregateId, Optional<Long> expectedLatestEventOrder) {
            PersistedEvent lastEventPersisted;
            log.trace("Trying to load {} with id '{}' and expectedLatestEventOrder {}", new Object[]{this.aggregateRootImplementationType.getName(), aggregateId, expectedLatestEventOrder});
            UnitOfWork unitOfWork = this.unitOfWorkFactory.getRequiredUnitOfWork();
            Optional potentialPersistedEventStream = this.eventStore.fetchStream(this.aggregateType, aggregateId, LongRange.from((long)EventOrder.FIRST_EVENT_ORDER.longValue()));
            if (potentialPersistedEventStream.isEmpty()) {
                log.trace("Didn't find a {} with id '{}'", (Object)this.aggregateRootImplementationType.getName(), aggregateId);
                return Optional.empty();
            }
            AggregateEventStream persistedEventsStream = (AggregateEventStream)potentialPersistedEventStream.get();
            if (expectedLatestEventOrder.isPresent() && (lastEventPersisted = (PersistedEvent)persistedEventsStream.eventList().get(persistedEventsStream.eventList().size() - 1)).eventOrder().longValue() != expectedLatestEventOrder.get().longValue()) {
                log.trace("Found {} with id '{}' but expectedLatestEventOrder {} != actualLatestEventOrder {}", new Object[]{this.aggregateRootImplementationType.getName(), aggregateId, expectedLatestEventOrder.get(), lastEventPersisted.eventOrder()});
                throw new OptimisticAggregateLoadException(aggregateId, this.aggregateRootImplementationType, expectedLatestEventOrder.map(EventOrder::of).get(), lastEventPersisted.eventOrder());
            }
            log.debug("Found {} with id '{}' and expectedLatestEventOrder {}", new Object[]{this.aggregateRootImplementationType.getName(), aggregateId, expectedLatestEventOrder});
            FlexAggregate aggregate = (FlexAggregate)Reflector.reflectOn(this.aggregateRootImplementationType).newInstance(new Object[0]);
            return Optional.of(aggregate.rehydrate(persistedEventsStream));
        }

        @Override
        public Class<AGGREGATE_TYPE> aggregateRootImplementationType() {
            return this.aggregateRootImplementationType;
        }

        @Override
        public void persist(EventsToPersist<ID, Object> eventsToPersist) {
            log.debug("Adding {} with id '{}' to the current UnitOfWork so it will be persisted at commit time", (Object)this.aggregateRootImplementationType.getName(), eventsToPersist.aggregateId);
            this.unitOfWorkFactory.getRequiredUnitOfWork().registerLifecycleCallbackForResource(eventsToPersist, (UnitOfWorkLifecycleCallback)this.unitOfWorkCallback);
        }

        @Override
        public Class<ID> aggregateIdType() {
            return this.aggregateIdType;
        }

        private class FlexAggregateRepositoryUnitOfWorkLifecycleCallback
        implements UnitOfWorkLifecycleCallback<EventsToPersist<ID, Object>> {
            private FlexAggregateRepositoryUnitOfWorkLifecycleCallback() {
            }

            public void beforeCommit(UnitOfWork unitOfWork, List<EventsToPersist<ID, Object>> associatedResources) {
                log.trace("beforeCommit processing {} '{}' registered with the UnitOfWork being committed", (Object)associatedResources.size(), (Object)DefaultFlexAggregateRepository.this.aggregateRootImplementationType.getName());
                associatedResources.forEach(eventsToPersist -> {
                    log.trace("beforeCommit processing '{}' with id '{}'", (Object)DefaultFlexAggregateRepository.this.aggregateRootImplementationType.getName(), eventsToPersist.aggregateId);
                    if (eventsToPersist.events.isEmpty()) {
                        log.trace("No changes detected for '{}' with id '{}'", (Object)DefaultFlexAggregateRepository.this.aggregateRootImplementationType.getName(), eventsToPersist.aggregateId);
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace("Persisting {} event(s) related to '{}' with id '{}': {}", new Object[]{eventsToPersist.events.size(), DefaultFlexAggregateRepository.this.aggregateRootImplementationType.getName(), eventsToPersist.aggregateId, eventsToPersist.events.stream().map(persistableEvent -> persistableEvent.getClass().getName()).reduce((s, s2) -> s + ", " + s2)});
                        } else {
                            log.debug("Persisting {} event(s) related to '{}' with id '{}'", new Object[]{eventsToPersist.events.size(), DefaultFlexAggregateRepository.this.aggregateRootImplementationType.getName(), eventsToPersist.aggregateId});
                        }
                        DefaultFlexAggregateRepository.this.eventStore.appendToStream(DefaultFlexAggregateRepository.this.aggregateType, eventsToPersist.aggregateId, eventsToPersist.eventOrderOfLastRehydratedEvent, eventsToPersist.events);
                        eventsToPersist.markEventsAsCommitted();
                    }
                });
            }

            public void afterCommit(UnitOfWork unitOfWork, List<EventsToPersist<ID, Object>> associatedResources) {
            }

            public void beforeRollback(UnitOfWork unitOfWork, List<EventsToPersist<ID, Object>> associatedResources, Exception causeOfTheRollback) {
            }

            public void afterRollback(UnitOfWork unitOfWork, List<EventsToPersist<ID, Object>> associatedResources, Exception causeOfTheRollback) {
            }
        }
    }
}

