/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AddNewAggregateSnapshotStrategy;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AggregateSnapshot;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AggregateSnapshotDeletionStrategy;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AggregateSnapshotRepository;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.BrokenSnapshot;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.ConfigurableEventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateType;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.PersistedEvent;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.persistence.AggregateEventStreamConfiguration;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.serializer.json.JSONEventSerializer;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.components.foundation.postgresql.PostgresqlUtil;
import dk.cloudcreate.essentials.components.foundation.transaction.jdbi.HandleAwareUnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.jdbi.HandleAwareUnitOfWorkFactory;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.collections.Lists;
import dk.cloudcreate.essentials.shared.reflection.Classes;
import dk.cloudcreate.essentials.types.NumberType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresqlAggregateSnapshotRepository
implements AggregateSnapshotRepository {
    private static final Logger log = LoggerFactory.getLogger(PostgresqlAggregateSnapshotRepository.class);
    public static final String DEFAULT_AGGREGATE_SNAPSHOTS_TABLE_NAME = "aggregate_snapshots";
    private final ConfigurableEventStore<? extends AggregateEventStreamConfiguration> eventStore;
    private final HandleAwareUnitOfWorkFactory<? extends HandleAwareUnitOfWork> unitOfWorkFactory;
    private final String snapshotTableName;
    private final JSONEventSerializer jsonSerializer;
    private final AggregateSnapshotRowMapper aggregateSnapshotWithSnapshotPayloadRowMapper;
    private final AggregateSnapshotRowMapper aggregateSnapshotWithoutSnapshotPayloadRowMapper;
    private final AddNewAggregateSnapshotStrategy addNewSnapshotStrategy;
    private final AggregateSnapshotDeletionStrategy snapshotDeletionStrategy;

    public PostgresqlAggregateSnapshotRepository(ConfigurableEventStore<? extends AggregateEventStreamConfiguration> eventStore, HandleAwareUnitOfWorkFactory<? extends HandleAwareUnitOfWork> unitOfWorkFactory, JSONEventSerializer jsonSerializer) {
        this(eventStore, unitOfWorkFactory, Optional.empty(), jsonSerializer, AddNewAggregateSnapshotStrategy.updateWhenBehindByNumberOfEvents(10L), AggregateSnapshotDeletionStrategy.deleteAllHistoricSnapshots());
    }

    public PostgresqlAggregateSnapshotRepository(ConfigurableEventStore<? extends AggregateEventStreamConfiguration> eventStore, HandleAwareUnitOfWorkFactory<? extends HandleAwareUnitOfWork> unitOfWorkFactory, String snapshotTableName, JSONEventSerializer jsonSerializer) {
        this(eventStore, unitOfWorkFactory, Optional.ofNullable(snapshotTableName), jsonSerializer, AddNewAggregateSnapshotStrategy.updateWhenBehindByNumberOfEvents(10L), AggregateSnapshotDeletionStrategy.deleteAllHistoricSnapshots());
    }

    public PostgresqlAggregateSnapshotRepository(ConfigurableEventStore<? extends AggregateEventStreamConfiguration> eventStore, HandleAwareUnitOfWorkFactory<? extends HandleAwareUnitOfWork> unitOfWorkFactory, String snapshotTableName, JSONEventSerializer jsonSerializer, AddNewAggregateSnapshotStrategy addNewSnapshotStrategy, AggregateSnapshotDeletionStrategy snapshotDeletionStrategy) {
        this(eventStore, unitOfWorkFactory, Optional.ofNullable(snapshotTableName), jsonSerializer, addNewSnapshotStrategy, snapshotDeletionStrategy);
    }

    public PostgresqlAggregateSnapshotRepository(ConfigurableEventStore<? extends AggregateEventStreamConfiguration> eventStore, HandleAwareUnitOfWorkFactory<? extends HandleAwareUnitOfWork> unitOfWorkFactory, JSONEventSerializer jsonSerializer, AddNewAggregateSnapshotStrategy addNewSnapshotStrategy, AggregateSnapshotDeletionStrategy snapshotDeletionStrategy) {
        this(eventStore, unitOfWorkFactory, Optional.empty(), jsonSerializer, addNewSnapshotStrategy, snapshotDeletionStrategy);
    }

    public PostgresqlAggregateSnapshotRepository(ConfigurableEventStore<? extends AggregateEventStreamConfiguration> eventStore, HandleAwareUnitOfWorkFactory<? extends HandleAwareUnitOfWork> unitOfWorkFactory, Optional<String> snapshotTableName, JSONEventSerializer jsonSerializer, AddNewAggregateSnapshotStrategy addNewSnapshotStrategy, AggregateSnapshotDeletionStrategy snapshotDeletionStrategy) {
        this.eventStore = (ConfigurableEventStore)FailFast.requireNonNull(eventStore, (String)"No eventStore instance provided");
        this.unitOfWorkFactory = (HandleAwareUnitOfWorkFactory)FailFast.requireNonNull(unitOfWorkFactory, (String)"No unitOfWorkFactory instance provided");
        this.snapshotTableName = ((Optional)FailFast.requireNonNull(snapshotTableName, (String)"No snapshotTableName provided")).orElse(DEFAULT_AGGREGATE_SNAPSHOTS_TABLE_NAME).toLowerCase();
        this.jsonSerializer = (JSONEventSerializer)FailFast.requireNonNull((Object)jsonSerializer, (String)"No jsonSerializer instance provided");
        this.addNewSnapshotStrategy = (AddNewAggregateSnapshotStrategy)FailFast.requireNonNull((Object)addNewSnapshotStrategy, (String)"No snapshotUpdateStrategy instance provided");
        this.snapshotDeletionStrategy = (AggregateSnapshotDeletionStrategy)FailFast.requireNonNull((Object)snapshotDeletionStrategy, (String)"No snapshotDeletionStrategy instance provided");
        this.aggregateSnapshotWithSnapshotPayloadRowMapper = new AggregateSnapshotRowMapper(true);
        this.aggregateSnapshotWithoutSnapshotPayloadRowMapper = new AggregateSnapshotRowMapper(false);
        this.initializeStorage();
    }

    private void initializeStorage() {
        PostgresqlUtil.checkIsValidTableOrColumnName((String)this.snapshotTableName);
        this.unitOfWorkFactory.withUnitOfWork(uow -> uow.handle().execute("CREATE TABLE IF NOT EXISTS " + this.snapshotTableName + " (\naggregate_impl_type TEXT NOT NULL,\naggregate_id TEXT NOT NULL,\naggregate_type TEXT NOT NULL,\nlast_included_event_order bigint NOT NULL,\nsnapshot JSONB NOT NULL,\ncreated_ts TIMESTAMP WITH TIME ZONE NOT NULL,\nstatistics JSONB,\nPRIMARY KEY (aggregate_impl_type,              aggregate_id,             last_included_event_order)\n)", new Object[0]));
        log.info("Ensured that aggregate snapshot table '{}' exists", (Object)this.snapshotTableName);
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> Optional<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> loadSnapshot(AggregateType aggregateType, ID aggregateId, EventOrder withLastIncludedEventOrderLessThanOrEqualTo, Class<AGGREGATE_IMPL_TYPE> aggregateImplType) {
        FailFast.requireNonNull((Object)aggregateType, (String)"No aggregateType supplied");
        FailFast.requireNonNull(aggregateId, (String)"No aggregateId supplied");
        FailFast.requireNonNull((Object)withLastIncludedEventOrderLessThanOrEqualTo, (String)"No withLastIncludedEventOrderLessThanOrEqualTo supplied");
        FailFast.requireNonNull(aggregateImplType, (String)"No aggregateImplType supplied");
        AggregateEventStreamConfiguration config = this.eventStore.getAggregateEventStreamConfiguration(aggregateType);
        String serializedAggregateId = config.aggregateIdSerializer.serialize(aggregateId);
        return (Optional)this.unitOfWorkFactory.withUnitOfWork(uow -> ((Query)((Query)((Query)uow.handle().createQuery("SELECT * FROM " + this.snapshotTableName + " WHERE aggregate_impl_type = :aggregate_impl_type AND aggregate_id = :aggregate_id AND last_included_event_order <= :last_included_event_order").bind("aggregate_impl_type", aggregateImplType.getName())).bind("aggregate_id", serializedAggregateId)).bind("last_included_event_order", (Object)withLastIncludedEventOrderLessThanOrEqualTo)).map((RowMapper)this.aggregateSnapshotWithSnapshotPayloadRowMapper).map(snapshot -> snapshot).findOne());
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> void aggregateUpdated(AGGREGATE_IMPL_TYPE aggregate, AggregateEventStream<ID> persistedEvents) {
        FailFast.requireNonNull(aggregate, (String)"No aggregate instance supplied");
        FailFast.requireNonNull(persistedEvents, (String)"No persistedEvents stream supplied");
        this.unitOfWorkFactory.usingUnitOfWork(uow -> {
            Optional<EventOrder> mostRecentlyStoredSnapshotLastIncludedEventOrder;
            AggregateType aggregateType = persistedEvents.aggregateType();
            AggregateEventStreamConfiguration config = this.eventStore.getAggregateEventStreamConfiguration(aggregateType);
            String serializedAggregateId = config.aggregateIdSerializer.serialize(persistedEvents.aggregateId());
            String aggregateImplType = aggregate.getClass().getName();
            if (this.shouldWeAddANewAggregateSnapshot(aggregate, persistedEvents, aggregateType, aggregateImplType, mostRecentlyStoredSnapshotLastIncludedEventOrder = this.findMostRecentLastIncludedEventOrderFor(serializedAggregateId, aggregateImplType, (HandleAwareUnitOfWork)uow))) {
                this.deleteHistoricSnapShotsIfNecessary(aggregate, persistedEvents, (HandleAwareUnitOfWork)uow, aggregateType, serializedAggregateId, aggregateImplType);
                EventOrder lastAppliedEventOrder = ((PersistedEvent)Lists.last((List)persistedEvents.eventList()).get()).eventOrder();
                int rowsUpdated = ((Update)((Update)((Update)((Update)((Update)((Update)uow.handle().createUpdate("INSERT INTO " + this.snapshotTableName + "(\naggregate_impl_type, aggregate_id, aggregate_type, last_included_event_order, snapshot, created_ts\n) VALUES (\n:aggregate_impl_type, :aggregate_id, :aggregate_type, :last_included_event_order, :snapshot::jsonb, :created_ts\n) ON CONFLICT DO NOTHING").bind("aggregate_impl_type", aggregateImplType)).bind("aggregate_id", serializedAggregateId)).bind("aggregate_type", (Object)aggregateType.value())).bind("last_included_event_order", lastAppliedEventOrder.longValue())).bind("snapshot", this.jsonSerializer.serialize(aggregate))).bind("created_ts", (Object)OffsetDateTime.now(Clock.systemUTC()))).execute();
                if (rowsUpdated == 1) {
                    log.debug("[{}:{}] Updated Aggregate Snapshot for '{}' and last_included_event_order {}", new Object[]{aggregateType, persistedEvents.aggregateId(), aggregateImplType, lastAppliedEventOrder});
                } else {
                    log.debug("[{}:{}] No rows updated when trying to update Aggregate Snapshot for '{}' and last_included_event_order {}", new Object[]{aggregateType, persistedEvents.aggregateId(), aggregateImplType, lastAppliedEventOrder});
                }
            }
        });
    }

    private <ID, AGGREGATE_IMPL_TYPE> boolean shouldWeAddANewAggregateSnapshot(AGGREGATE_IMPL_TYPE aggregate, AggregateEventStream<ID> persistedEvents, AggregateType aggregateType, String aggregateImplType, Optional<EventOrder> mostRecentlyStoredSnapshotLastIncludedEventOrder) {
        if (this.addNewSnapshotStrategy.shouldANewAggregateSnapshotBeAdded(aggregate, persistedEvents, mostRecentlyStoredSnapshotLastIncludedEventOrder)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}:{}] {} strategy determined to ADD a new Aggregate Snapshot for '{}' based on mostRecentlyStoredSnapshotLastIncludedEventOrder {} and persistedEvents->eventOrders: {}", new Object[]{aggregateType, persistedEvents.aggregateId(), this.addNewSnapshotStrategy, aggregateImplType, mostRecentlyStoredSnapshotLastIncludedEventOrder, persistedEvents.eventList().stream().map(persistedEvent -> persistedEvent.eventOrder().longValue()).collect(Collectors.toList())});
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}:{}] {} strategy determined NOT to add a new Aggregate Snapshot for '{}' based on mostRecentlyStoredSnapshotLastIncludedEventOrder {} and persistedEvents->eventOrders: {}", new Object[]{aggregateType, persistedEvents.aggregateId(), this.addNewSnapshotStrategy, aggregateImplType, mostRecentlyStoredSnapshotLastIncludedEventOrder, persistedEvents.eventList().stream().map(persistedEvent -> persistedEvent.eventOrder().longValue()).collect(Collectors.toList())});
        }
        return false;
    }

    protected Optional<EventOrder> findMostRecentLastIncludedEventOrderFor(String serializedAggregateId, String aggregateImplType, HandleAwareUnitOfWork uow) {
        return ((Query)((Query)uow.handle().createQuery("SELECT coalesce(MAX(last_included_event_order), -1) FROM " + this.snapshotTableName + " WHERE aggregate_impl_type = :aggregate_impl_type AND aggregate_id = :aggregate_id").bind("aggregate_impl_type", aggregateImplType)).bind("aggregate_id", serializedAggregateId)).mapTo(EventOrder.class).findOne();
    }

    private <ID, AGGREGATE_IMPL_TYPE> void deleteHistoricSnapShotsIfNecessary(AGGREGATE_IMPL_TYPE aggregate, AggregateEventStream<ID> persistedEvents, HandleAwareUnitOfWork uow, AggregateType aggregateType, String serializedAggregateId, String aggregateImplType) {
        if (this.snapshotDeletionStrategy.requiresExistingSnapshotDetailsToDetermineWhichAggregateSnapshotsToDelete()) {
            Stream<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> snapshotEventOrdersToDeleteStream;
            List<EventOrder> eventOrdersToDelete;
            List<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> existingSnapshots = this.loadAllSnapshots(serializedAggregateId, aggregateImplType, false, uow);
            if (log.isDebugEnabled()) {
                log.debug("[{}:{}] Found {} {}'s Aggregate-Snapshots with eventOrderOfLastIncludedEvent: {}", new Object[]{aggregateType, persistedEvents.aggregateId(), existingSnapshots.size(), aggregateImplType, existingSnapshots.stream().map(snapshot -> snapshot.eventOrderOfLastIncludedEvent.longValue()).collect(Collectors.toList())});
            }
            if (!existingSnapshots.isEmpty() && !(eventOrdersToDelete = (snapshotEventOrdersToDeleteStream = this.snapshotDeletionStrategy.resolveSnapshotsToDelete(existingSnapshots)).map(snapshot -> snapshot.eventOrderOfLastIncludedEvent).collect(Collectors.toList())).isEmpty()) {
                log.debug("[{}:{}] Will delete {} Historic {}'s Aggregate-Snapshots with eventOrderOfLastIncludedEvent: {}", new Object[]{aggregateType, persistedEvents.aggregateId(), eventOrdersToDelete.size(), aggregateImplType, eventOrdersToDelete});
                this.deleteSnapshots(aggregateType, persistedEvents.aggregateId(), aggregate.getClass(), eventOrdersToDelete);
            }
        } else {
            this.deleteSnapshots(aggregateType, persistedEvents.aggregateId(), aggregate.getClass());
        }
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> List<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> loadAllSnapshots(AggregateType aggregateType, ID aggregateId, Class<AGGREGATE_IMPL_TYPE> aggregateImplType, boolean includeSnapshotPayload) {
        FailFast.requireNonNull((Object)aggregateType, (String)"No aggregateType supplied");
        FailFast.requireNonNull(aggregateId, (String)"No aggregateId supplied");
        FailFast.requireNonNull(aggregateImplType, (String)"No aggregateImplType supplied");
        AggregateEventStreamConfiguration config = this.eventStore.getAggregateEventStreamConfiguration(aggregateType);
        String serializedAggregateId = config.aggregateIdSerializer.serialize(aggregateId);
        return (List)this.unitOfWorkFactory.withUnitOfWork(uow -> this.loadAllSnapshots(serializedAggregateId, aggregateImplType.getName(), includeSnapshotPayload, (HandleAwareUnitOfWork)uow));
    }

    protected <ID, AGGREGATE_IMPL_TYPE> List<AggregateSnapshot<ID, AGGREGATE_IMPL_TYPE>> loadAllSnapshots(String serializedAggregateId, String aggregateImplType, boolean includeSnapshotPayload, HandleAwareUnitOfWork uow) {
        String selectColumns = includeSnapshotPayload ? "*" : "aggregate_impl_type, aggregate_id, aggregate_type, last_included_event_order, created_ts, statistics";
        return ((Query)((Query)uow.handle().createQuery("SELECT " + selectColumns + " FROM " + this.snapshotTableName + " WHERE aggregate_impl_type = :aggregate_impl_type AND aggregate_id = :aggregate_id ORDER BY last_included_event_order ASC").bind("aggregate_impl_type", aggregateImplType)).bind("aggregate_id", serializedAggregateId)).map((RowMapper)(includeSnapshotPayload ? this.aggregateSnapshotWithSnapshotPayloadRowMapper : this.aggregateSnapshotWithoutSnapshotPayloadRowMapper)).map(snapshot -> snapshot).list();
    }

    @Override
    public <AGGREGATE_IMPL_TYPE> void deleteAllSnapshots(Class<AGGREGATE_IMPL_TYPE> ofAggregateImplementationType) {
        FailFast.requireNonNull(ofAggregateImplementationType, (String)"No ofAggregateImplementationType supplied");
        Integer rowsUpdated = (Integer)this.unitOfWorkFactory.withUnitOfWork(uow -> ((Update)uow.handle().createUpdate("DELETE FROM " + this.snapshotTableName + " WHERE aggregate_impl_type = :aggregate_impl_type").bind("aggregate_impl_type", ofAggregateImplementationType.getName())).execute());
        log.debug("Deleted {} historic snapshots related to Aggregate implementation type '{}'", (Object)rowsUpdated, (Object)ofAggregateImplementationType.getName());
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> void deleteSnapshots(AggregateType aggregateType, ID aggregateId, Class<AGGREGATE_IMPL_TYPE> withAggregateImplementationType) {
        FailFast.requireNonNull((Object)aggregateType, (String)"No aggregateType supplied");
        FailFast.requireNonNull(aggregateId, (String)"No aggregateId supplied");
        FailFast.requireNonNull(withAggregateImplementationType, (String)"No withAggregateImplementationType supplied");
        AggregateEventStreamConfiguration config = this.eventStore.getAggregateEventStreamConfiguration(aggregateType);
        String serializedAggregateId = config.aggregateIdSerializer.serialize(aggregateId);
        Integer rowsUpdated = (Integer)this.unitOfWorkFactory.withUnitOfWork(uow -> ((Update)((Update)uow.handle().createUpdate("DELETE FROM " + this.snapshotTableName + " WHERE aggregate_impl_type = :aggregate_impl_type AND aggregate_id = :aggregate_id").bind("aggregate_impl_type", withAggregateImplementationType.getName())).bind("aggregate_id", serializedAggregateId)).execute());
        log.debug("Deleted {} historic snapshots related to Aggregate '{}' with id '{}'", new Object[]{rowsUpdated, withAggregateImplementationType.getName(), aggregateId});
    }

    @Override
    public <ID, AGGREGATE_IMPL_TYPE> void deleteSnapshots(AggregateType aggregateType, ID aggregateId, Class<AGGREGATE_IMPL_TYPE> withAggregateImplementationType, List<EventOrder> snapshotEventOrdersToDelete) {
        FailFast.requireNonNull((Object)aggregateType, (String)"No aggregateType supplied");
        FailFast.requireNonNull(aggregateId, (String)"No aggregateId supplied");
        FailFast.requireNonNull(withAggregateImplementationType, (String)"No withAggregateImplementationType supplied");
        FailFast.requireNonEmpty(snapshotEventOrdersToDelete, (String)"snapshotEventOrdersToDelete may not be null or empty");
        AggregateEventStreamConfiguration config = this.eventStore.getAggregateEventStreamConfiguration(aggregateType);
        String serializedAggregateId = config.aggregateIdSerializer.serialize(aggregateId);
        Integer rowsUpdated = (Integer)this.unitOfWorkFactory.withUnitOfWork(uow -> ((Update)((Update)((Update)uow.handle().createUpdate("DELETE FROM " + this.snapshotTableName + " WHERE aggregate_impl_type = :aggregate_impl_type AND aggregate_id = :aggregate_id AND last_included_event_order IN (<snapshotEventOrdersToDelete>)").bind("aggregate_impl_type", withAggregateImplementationType.getName())).bind("aggregate_id", serializedAggregateId)).bindList("snapshotEventOrdersToDelete", (Iterable)snapshotEventOrdersToDelete.stream().map(NumberType::longValue).collect(Collectors.toList()))).execute());
        log.debug("Deleted {} historic snapshots related to Aggregate '{}' with id '{}' and snapshotEventOrdersToDelete: {}", new Object[]{rowsUpdated, withAggregateImplementationType.getName(), aggregateId, snapshotEventOrdersToDelete});
    }

    private class AggregateSnapshotRowMapper
    implements RowMapper<AggregateSnapshot> {
        private final boolean resultSetContainsSnapshotPayload;

        public AggregateSnapshotRowMapper(boolean resultSetContainsSnapshotPayload) {
            this.resultSetContainsSnapshotPayload = resultSetContainsSnapshotPayload;
        }

        public AggregateSnapshot map(ResultSet rs, StatementContext ctx) throws SQLException {
            AggregateType aggregateType = AggregateType.of((CharSequence)rs.getString("aggregate_type"));
            AggregateEventStreamConfiguration config = PostgresqlAggregateSnapshotRepository.this.eventStore.getAggregateEventStreamConfiguration(aggregateType);
            Class aggregateImplType = Classes.forName((String)rs.getString("aggregate_impl_type"));
            Object aggregateId = config.aggregateIdSerializer.deserialize(rs.getString("aggregate_id"));
            Object snapshotPayload = this.deserializeSnapshot(rs, aggregateId, aggregateImplType);
            return new AggregateSnapshot<Object, Object>(aggregateType, aggregateId, aggregateImplType, snapshotPayload, EventOrder.of((long)rs.getLong("last_included_event_order")));
        }

        private Object deserializeSnapshot(ResultSet rs, Object aggregateId, Class<?> aggregateImplType) throws SQLException {
            try {
                return this.resultSetContainsSnapshotPayload ? PostgresqlAggregateSnapshotRepository.this.jsonSerializer.deserialize(rs.getString("snapshot"), aggregateImplType) : null;
            }
            catch (Exception e) {
                log.error(MessageFormatter.msg((String)"Failed to deserialize '{}' with id '{}'", (Object[])new Object[]{aggregateImplType, aggregateId}), (Throwable)e);
                return new BrokenSnapshot(e);
            }
        }
    }
}

